package com.adlibsoftware.integration;

import com.adlibsoftware.client.JobState;
import com.adlibsoftware.client.Payload;

/**
 * Stores the Payload, ID, and status of Processed Job
 * @author mmanley
 * @see com.adlibsoftware.integration.JobManagementServiceClient 
 *
 */
public class ProcessedJobResponse {

	private Payload outputPayload;
	
	private Long fileId;
	
	private boolean isSuccessful;
	
	private String exceptionInfo;
	
	private JobState jobState;
	
	private Long lastJobId;

	/**
	 * @return the outputPayload
	 */
	public Payload getOutputPayload() {
		return outputPayload;
	}

	/**
	 * @param outputPayload the outputPayload to set
	 */
	public void setOutputPayload(Payload outputPayload) {
		this.outputPayload = outputPayload;
	}

	/**
	 * @return the fileId
	 */
	public Long getFileId() {
		return fileId;
	}

	/**
	 * @param fileId the fileId to set
	 */
	public void setFileId(Long fileId) {
		this.fileId = fileId;
	}

	/**
	 * @return the isSuccessful
	 */
	public boolean isSuccessful() {
		return isSuccessful;
	}

	/**
	 * @param isSuccessful the isSuccessful to set
	 */
	public void setSuccessful(boolean isSuccessful) {
		this.isSuccessful = isSuccessful;
	}

	/**
	 * @return the jobState
	 */
	public JobState getJobState() {
		return jobState;
	}

	/**
	 * @param jobState the jobState to set
	 */
	public void setJobState(JobState jobState) {
		this.jobState = jobState;
	}

	/**
	 * @return the exceptionInfo when not successful
	 */
	public String getExceptionInfo() {
		return exceptionInfo;
	}

	/**
	 * @param exceptionInfo the exceptionInfo to set
	 */
	public void setExceptionInfo(String exceptionInfo) {
		this.exceptionInfo = exceptionInfo;
	}

	/**
	 * @return the lastJobId
	 */
	public Long getLastJobId() {
		return lastJobId;
	}

	/**
	 * @param lastJobId the lastJobId to set
	 */
	public void setLastJobId(Long lastJobId) {
		this.lastJobId = lastJobId;
	}
}
