/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.models;

import com.adobe.acs.commons.redirects.models.RedirectState;
import com.adobe.acs.commons.redirects.models.SubstitutionElement;
import com.adobe.granite.security.user.util.AuthorizableUtil;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.PostConstruct;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class RedirectRule {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SOURCE_PROPERTY_NAME = "source";
    public static final String TARGET_PROPERTY_NAME = "target";
    public static final String STATUS_CODE_PROPERTY_NAME = "statusCode";
    public static final String UNTIL_DATE_PROPERTY_NAME = "untilDate";
    public static final String EFFECTIVE_FROM_PROPERTY_NAME = "effectiveFrom";
    public static final String NOTE_PROPERTY_NAME = "note";
    public static final String CONTEXT_PREFIX_IGNORED_PROPERTY_NAME = "contextPrefixIgnored";
    public static final String EVALUATE_URI_PROPERTY_NAME = "evaluateURI";
    public static final String CREATED_PROPERTY_NAME = "jcr:created";
    public static final String CREATED_BY_PROPERTY_NAME = "jcr:createdBy";
    public static final String MODIFIED_PROPERTY_NAME = "jcr:lastModified";
    public static final String MODIFIED_BY_PROPERTY_NAME = "jcr:lastModifiedBy";
    public static final String TAGS_PROPERTY_NAME = "cq:tags";
    public static final String CACHE_CONTROL_HEADER_NAME = "cacheControlHeader";
    @ValueMapValue(injectionStrategy=InjectionStrategy.REQUIRED)
    private String source;
    @ValueMapValue(injectionStrategy=InjectionStrategy.REQUIRED)
    private String target;
    @ValueMapValue(injectionStrategy=InjectionStrategy.REQUIRED)
    private int statusCode;
    @ValueMapValue
    private boolean evaluateURI;
    @ValueMapValue
    private Calendar untilDate;
    @ValueMapValue
    private Calendar effectiveFrom;
    @ValueMapValue
    private String note;
    @ValueMapValue
    private boolean contextPrefixIgnored;
    @ValueMapValue(name="cq:tags")
    private String[] tagIds;
    @ValueMapValue(name="jcr:createdBy")
    private String createdBy;
    @ValueMapValue(name="jcr:lastModifiedBy")
    private String modifiedBy;
    @ValueMapValue(name="jcr:lastModified")
    private Calendar modified;
    @ValueMapValue(name="jcr:created")
    private Calendar created;
    @ValueMapValue(name="cacheControlHeader")
    private String cacheControlHeader;
    @Self
    private Resource resource;
    private Pattern ptrn;
    private SubstitutionElement[] substitutions;
    private String defaultCacheControlHeader = null;

    @PostConstruct
    protected void init() {
        this.source = this.source.trim();
        this.target = this.target.trim();
        this.createdBy = AuthorizableUtil.getFormattedName((ResourceResolver)this.resource.getResourceResolver(), (String)this.createdBy);
        this.modifiedBy = AuthorizableUtil.getFormattedName((ResourceResolver)this.resource.getResourceResolver(), (String)this.modifiedBy);
        String regex = this.source;
        if (regex.endsWith("*")) {
            regex = regex.replaceAll("\\*$", "(.*)");
        }
        this.ptrn = RedirectRule.toRegex(regex);
        this.substitutions = SubstitutionElement.parse(this.target);
        String cacheControlProperty = "cacheControlHeader_" + this.getStatusCode();
        this.defaultCacheControlHeader = (String)this.resource.getParent().getValueMap().get(cacheControlProperty, String.class);
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public String getNote() {
        return this.note;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean getEvaluateURI() {
        return this.evaluateURI;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getContextPrefixIgnored() {
        return this.contextPrefixIgnored;
    }

    public Pattern getRegex() {
        return this.ptrn;
    }

    public Calendar getCreated() {
        return this.created;
    }

    public Calendar getModified() {
        return this.modified;
    }

    public Calendar getUntilDate() {
        return this.untilDate;
    }

    public Calendar getEffectiveFrom() {
        return this.effectiveFrom;
    }

    public String[] getTagIds() {
        return this.tagIds;
    }

    public String getCacheControlHeader() {
        return this.cacheControlHeader;
    }

    public String getDefaultCacheControlHeader() {
        return this.defaultCacheControlHeader;
    }

    public List<Tag> getTags() {
        TagManager tagMgr = (TagManager)this.resource.getResourceResolver().adaptTo(TagManager.class);
        if (this.tagIds == null || tagMgr == null) {
            return Collections.emptyList();
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (String tagId : this.tagIds) {
            Tag tag = tagMgr.resolve(tagId);
            if (tag == null) continue;
            tags.add(tag);
        }
        return tags;
    }

    public String toString() {
        return String.format("RedirectRule{source='%s', target='%s', statusCode=%s, untilDate=%s, effectiveFrom=%s, note=%s, evaluateURI=%s,contextPrefixIgnored=%s, tags=%s, created=%s, createdBy=%s, modified=%s, modifiedBy=%s, cacheControlHeader=%s}", this.source, this.target, this.statusCode, this.untilDate, this.effectiveFrom, this.note, this.evaluateURI, this.contextPrefixIgnored, Arrays.toString(this.tagIds), this.created, this.createdBy, this.modified, this.modifiedBy, this.cacheControlHeader);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedirectRule that = (RedirectRule)o;
        return Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return this.source != null ? this.source.hashCode() : 0;
    }

    public String evaluate(Matcher matcher) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.substitutions.length; ++i) {
            buf.append(this.substitutions[i].evaluate(matcher));
        }
        return buf.toString();
    }

    static Pattern toRegex(String src) {
        Pattern ptrn;
        try {
            ptrn = Pattern.compile(src);
            int groupCount = ptrn.matcher("").groupCount();
            if (groupCount == 0) {
                ptrn = null;
            }
        }
        catch (PatternSyntaxException e) {
            log.info("invalid regex: {}", (Object)src);
            ptrn = null;
        }
        return ptrn;
    }

    public RedirectState getState() {
        boolean invalid;
        boolean expired = this.untilDate != null && this.untilDate.before(Calendar.getInstance());
        boolean pending = this.effectiveFrom != null && Calendar.getInstance().before(this.effectiveFrom);
        boolean bl = invalid = this.effectiveFrom != null && this.untilDate != null && this.effectiveFrom.after(this.untilDate);
        if (invalid) {
            return RedirectState.INVALID;
        }
        if (expired) {
            return RedirectState.EXPIRED;
        }
        if (pending) {
            return RedirectState.PENDING;
        }
        return RedirectState.ACTIVE;
    }

    public boolean isPublished() {
        Calendar lastReplicated = (Calendar)this.resource.getParent().getValueMap().get("cq:lastReplicated", Calendar.class);
        boolean isPublished = lastReplicated != null;
        boolean modifiedAfterPublication = isPublished && (this.modified != null && this.modified.after(lastReplicated) || this.created != null && this.created.after(lastReplicated));
        return isPublished && !modifiedAfterPublication;
    }
}

