/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.synthetic.impl.granite;

import com.adobe.acs.commons.workflow.synthetic.SyntheticWorkflowModel;
import com.adobe.acs.commons.workflow.synthetic.impl.granite.exceptions.SyntheticWorkflowModelException;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.model.WorkflowModel;
import com.adobe.granite.workflow.model.WorkflowNode;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyntheticWorkflowModelImpl
implements SyntheticWorkflowModel {
    private static final Logger log = LoggerFactory.getLogger(SyntheticWorkflowModelImpl.class);
    private static final String WORKFLOW_MODEL_PATH_PREFIX = "/etc/workflow/models/";
    private static final String WORKFLOW_MODEL_PATH_SUFFIX = "/jcr:content/model";
    private Map<String, Map<String, Object>> syntheticWorkflowModel = new LinkedHashMap<String, Map<String, Object>>();

    public SyntheticWorkflowModelImpl(WorkflowSession workflowSession, String modelId, boolean ignoredIncompatibleTypes) throws WorkflowException {
        if (!StringUtils.startsWith((String)modelId, (String)WORKFLOW_MODEL_PATH_PREFIX)) {
            modelId = WORKFLOW_MODEL_PATH_PREFIX + modelId;
        }
        if (!StringUtils.endsWith((String)modelId, (String)WORKFLOW_MODEL_PATH_SUFFIX)) {
            modelId = modelId + WORKFLOW_MODEL_PATH_SUFFIX;
        }
        WorkflowModel model = workflowSession.getModel(modelId);
        log.debug("Located Workflow Model [ {} ] with modelId [ {} ]", (Object)model.getTitle(), (Object)modelId);
        List nodes = model.getNodes();
        for (WorkflowNode node : nodes) {
            String processName;
            if (!ignoredIncompatibleTypes && !this.isValidType(node)) {
                throw new SyntheticWorkflowModelException(node.getId() + " is of incompatible type " + node.getType());
            }
            if (node.getTransitions().size() > 1) {
                throw new SyntheticWorkflowModelException(node.getId() + " has unsupported decision based execution (more than 1 transitions is not allowed)");
            }
            log.debug("Workflow node title [ {} ]", (Object)node.getTitle());
            if (!this.isProcessType(node) || !StringUtils.isNotBlank((String)(processName = (String)node.getMetaDataMap().get("PROCESS", (Object)"")))) continue;
            log.debug("Adding Workflow Process [ {} ] to Synthetic Workflow", (Object)processName);
            this.syntheticWorkflowModel.put(processName, (Map<String, Object>)node.getMetaDataMap());
        }
    }

    @Override
    public final String[] getWorkflowProcessNames() {
        return this.syntheticWorkflowModel.keySet().toArray(new String[this.syntheticWorkflowModel.keySet().size()]);
    }

    @Override
    public final Map<String, Map<String, Object>> getSyntheticWorkflowModelData() {
        return this.syntheticWorkflowModel;
    }

    private boolean isValidType(WorkflowNode node) {
        return "START".equals(node.getType()) || "PROCESS".equals(node.getType());
    }

    private boolean isProcessType(WorkflowNode node) {
        return "PROCESS".equals(node.getType());
    }
}

