/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.models;

import java.util.Calendar;

public enum ExportColumn {
    SOURCE("Source Url", "source", Boolean.class, true),
    TARGET("Target Url", "target", Boolean.class, true),
    STATUS_CODE("Status Code", "statusCode", Integer.class, true),
    OFF_TIME("Off Time", "untilDate", Calendar.class, true),
    ON_TIME("On Time", "effectiveFrom", Calendar.class, true),
    NOTES("Notes", "note", String.class, true),
    EVALUATE_URI("Evaluate URI", "evaluateURI", Boolean.class, true),
    IGNORE_CONTEXT_PREFIX("Ignore Context Prefix", "contextPrefixIgnored", Boolean.class, true),
    TAGS("Tags", "cq:tags", String[].class, true),
    CREATED("Created", "jcr:created", Calendar.class, false),
    CREATED_BY("Created By", "jcr:createdBy", String.class, false),
    MODIFIED("Modified", "jcr:lastModified", Calendar.class, false),
    MODIFIED_BY("Modified By", "jcr:lastModifiedBy", String.class, false);

    private final String title;
    private final String propertyName;
    private final Class<?> type;
    private final boolean importable;

    private ExportColumn(String title, String propertyName, Class<?> type, boolean importable) {
        this.title = title;
        this.propertyName = propertyName;
        this.type = type;
        this.importable = importable;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<?> getPropertyType() {
        return this.type;
    }

    public boolean isImportable() {
        return this.importable;
    }
}

