/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.servlets;

import com.adobe.acs.commons.redirects.filter.RedirectFilter;
import com.adobe.acs.commons.redirects.models.ExportColumn;
import com.adobe.acs.commons.redirects.models.RedirectRule;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Collection;
import javax.servlet.Servlet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, immediate=true, name="ExportRedirectMapServlet", property={"sling.servlet.label=ACS AEM Commons - Export Redirects Servlet", "sling.servlet.methods=GET", "sling.servlet.selectors=export", "sling.servlet.resourceTypes=acs-commons/components/utilities/manage-redirects"})
public class ExportRedirectMapServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(ExportRedirectMapServlet.class);
    private static final long serialVersionUID = -3564475196678277711L;
    static final String SPREADSHEETML_SHEET = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String path = request.getParameter("path");
        Resource root = request.getResourceResolver().getResource(path);
        log.debug("Requesting redirect maps from {}", (Object)path);
        Collection<RedirectRule> rules = RedirectFilter.getRules(root);
        XSSFWorkbook wb = ExportRedirectMapServlet.export(rules);
        response.setContentType(SPREADSHEETML_SHEET);
        response.setHeader("Content-Disposition", "attachment;filename=\"acs-redirects.xlsx\" ");
        wb.write((OutputStream)response.getOutputStream());
    }

    static XSSFWorkbook export(Collection<RedirectRule> rules) {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFCellStyle headerStyle = wb.createCellStyle();
        headerStyle.setFillForegroundColor(IndexedColors.DARK_BLUE.getIndex());
        headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFFont headerFont = wb.createFont();
        headerFont.setColor(IndexedColors.WHITE.getIndex());
        headerStyle.setFont((Font)headerFont);
        XSSFCellStyle dateStyle = wb.createCellStyle();
        dateStyle.setDataFormat(wb.createDataFormat().getFormat("mmm d, yyyy"));
        XSSFCellStyle lockedCellStyle = wb.createCellStyle();
        lockedCellStyle.setLocked(true);
        XSSFCellStyle cellWrapStyle = wb.createCellStyle();
        cellWrapStyle.setWrapText(true);
        int rownum = 0;
        XSSFSheet sheet = wb.createSheet("Redirects");
        Row headerRow = sheet.createRow(rownum++);
        headerRow.createCell(0).setCellValue(ExportColumn.SOURCE.getTitle());
        headerRow.createCell(1).setCellValue(ExportColumn.TARGET.getTitle());
        headerRow.createCell(2).setCellValue(ExportColumn.STATUS_CODE.getTitle());
        headerRow.createCell(3).setCellValue(ExportColumn.OFF_TIME.getTitle());
        headerRow.createCell(4).setCellValue(ExportColumn.ON_TIME.getTitle());
        headerRow.createCell(5).setCellValue(ExportColumn.NOTES.getTitle());
        headerRow.createCell(6).setCellValue(ExportColumn.EVALUATE_URI.getTitle());
        headerRow.createCell(7).setCellValue(ExportColumn.IGNORE_CONTEXT_PREFIX.getTitle());
        headerRow.createCell(8).setCellValue(ExportColumn.TAGS.getTitle());
        headerRow.createCell(9).setCellValue(ExportColumn.CREATED.getTitle());
        headerRow.createCell(10).setCellValue(ExportColumn.CREATED_BY.getTitle());
        headerRow.createCell(11).setCellValue(ExportColumn.MODIFIED.getTitle());
        headerRow.createCell(12).setCellValue(ExportColumn.MODIFIED_BY.getTitle());
        sheet.setColumnWidth(0, 12800);
        sheet.setColumnWidth(1, 12800);
        sheet.setColumnWidth(2, 3840);
        sheet.setColumnWidth(3, 3072);
        sheet.setColumnWidth(4, 3072);
        sheet.setColumnWidth(5, 25600);
        sheet.setColumnWidth(6, 5120);
        sheet.setColumnWidth(7, 5120);
        sheet.setColumnWidth(8, 6400);
        sheet.setColumnWidth(9, 3072);
        sheet.setColumnWidth(10, 7680);
        sheet.setColumnWidth(11, 3072);
        sheet.setColumnWidth(12, 7680);
        for (Cell cell : headerRow) {
            cell.setCellStyle((CellStyle)headerStyle);
        }
        for (RedirectRule rule : rules) {
            Calendar effectiveFrom;
            Row row = sheet.createRow(rownum++);
            row.createCell(0).setCellValue(rule.getSource());
            row.createCell(1).setCellValue(rule.getTarget());
            row.createCell(2).setCellValue((double)rule.getStatusCode());
            Calendar untilDateTime = rule.getUntilDate();
            if (untilDateTime != null) {
                Cell cell = row.createCell(3);
                cell.setCellValue(untilDateTime);
                cell.setCellStyle((CellStyle)dateStyle);
            }
            if ((effectiveFrom = rule.getEffectiveFrom()) != null) {
                Cell cell = row.createCell(4);
                cell.setCellValue(effectiveFrom);
                cell.setCellStyle((CellStyle)dateStyle);
            }
            row.createCell(5).setCellValue(rule.getNote());
            row.createCell(6).setCellValue(rule.getEvaluateURI());
            row.createCell(7).setCellValue(rule.getContextPrefixIgnored());
            Cell cell6 = row.createCell(8);
            CharSequence[] tagIds = rule.getTagIds();
            if (tagIds != null) {
                cell6.setCellValue(String.join((CharSequence)"\n", tagIds));
            }
            cell6.setCellStyle((CellStyle)cellWrapStyle);
            Cell cell7 = row.createCell(9);
            cell7.setCellValue(rule.getCreated());
            cell7.setCellStyle((CellStyle)dateStyle);
            Cell cell8 = row.createCell(10);
            cell8.setCellValue(rule.getCreatedBy());
            cell8.setCellStyle((CellStyle)lockedCellStyle);
            Cell cell9 = row.createCell(11);
            cell9.setCellValue(rule.getModified());
            cell9.setCellStyle((CellStyle)dateStyle);
            Cell cell10 = row.createCell(12);
            cell10.setCellValue(rule.getModifiedBy());
            cell10.setCellStyle((CellStyle)lockedCellStyle);
        }
        sheet.setAutoFilter(new CellRangeAddress(0, rownum - 1, 0, 10));
        return wb;
    }
}

