/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.reports.models;

import com.adobe.acs.commons.reports.api.ReportCellCSVExporter;
import com.adobe.acs.commons.reports.internal.DelimiterConfiguration;
import com.adobe.acs.commons.reports.internal.ExporterUtil;
import com.adobe.acs.commons.reports.models.ReportCellValue;
import java.util.ArrayList;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;

@Model(adaptables={Resource.class})
public class StringReportCellCSVExporter
implements ReportCellCSVExporter {
    @Inject
    private String property;
    @Inject
    @Optional
    private String format;
    @OSGiService
    private DelimiterConfiguration delimiterConfiguration;

    public StringReportCellCSVExporter() {
    }

    StringReportCellCSVExporter(DelimiterConfiguration delimiterConfiguration) {
        this.delimiterConfiguration = delimiterConfiguration;
    }

    @Override
    public String getValue(Object result) {
        String relativePropertyPath = ExporterUtil.relativizePath(this.property);
        Resource resource = (Resource)result;
        ReportCellValue val = new ReportCellValue(resource, relativePropertyPath);
        ArrayList<String> values = new ArrayList<String>();
        if (val.getValue() != null) {
            if (val.isArray()) {
                for (String value : val.getMultipleValues()) {
                    values.add(value);
                }
            } else {
                values.add(val.getSingleValue());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.format)) {
            for (int i = 0; i < values.size(); ++i) {
                values.set(i, String.format(this.format, values.get(i)));
            }
        }
        return StringUtils.join(values, (String)this.delimiterConfiguration.getMultiValueDelimiter());
    }
}

