/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.contentsync;

import com.adobe.acs.commons.contentsync.CatalogItem;
import com.adobe.acs.commons.contentsync.RemoteInstance;
import com.adobe.acs.commons.contentsync.UpdateStrategy;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class ContentCatalog {
    private RemoteInstance remoteInstance;
    private final String catalogServlet;

    public ContentCatalog(RemoteInstance remoteInstance, String catalogServlet) {
        this.remoteInstance = remoteInstance;
        this.catalogServlet = catalogServlet;
    }

    @Deprecated
    public URI getFetchURI(String path, String updateStrategy) throws URISyntaxException {
        return this.getFetchURI(path, updateStrategy, true);
    }

    public URI getFetchURI(String path, String updateStrategy, boolean recursive) throws URISyntaxException {
        return this.remoteInstance.toURI(this.catalogServlet, "root", path, "strategy", updateStrategy, "recursive", String.valueOf(recursive));
    }

    @Deprecated
    public List<CatalogItem> fetch(String path, String updateStrategy) throws IOException, URISyntaxException {
        return this.fetch(path, updateStrategy, true);
    }

    public List<CatalogItem> fetch(String path, String updateStrategy, boolean recursive) throws IOException, URISyntaxException {
        JsonObject response;
        URI uri = this.getFetchURI(path, updateStrategy, recursive);
        String json = this.remoteInstance.getString(uri);
        try (JsonReader reader = Json.createReader((Reader)new StringReader(json));){
            response = reader.readObject();
        }
        if (!response.containsKey((Object)"resources")) {
            throw new IOException("Failed to fetch content catalog from " + uri + ", Response: " + json);
        }
        JsonArray catalog = response.getJsonArray("resources");
        return catalog.stream().map(JsonValue::asJsonObject).map(CatalogItem::new).collect(Collectors.toList());
    }

    public List<CatalogItem> getDelta(List<CatalogItem> catalog, ResourceResolver resourceResolver, UpdateStrategy updateStrategy) {
        ArrayList<CatalogItem> lst = new ArrayList<CatalogItem>();
        for (CatalogItem item : catalog) {
            Resource resource = resourceResolver.getResource(item.getPath());
            if (resource != null && !updateStrategy.isModified(item, resource)) continue;
            lst.add(item);
        }
        return lst;
    }
}

