/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.fam.actions;

import com.adobe.acs.commons.fam.actions.Actions;
import com.adobe.acs.commons.functions.CheckedBiConsumer;
import com.adobe.acs.commons.functions.CheckedBiFunction;
import com.adobe.acs.commons.functions.CheckedConsumer;
import com.adobe.granite.asset.api.Asset;
import com.adobe.granite.asset.api.AssetManager;
import com.adobe.granite.asset.api.Rendition;
import java.util.Iterator;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class AssetActions {
    public static final CheckedBiConsumer<ResourceResolver, String> REMOVE_ALL_RENDITIONS = (r, path) -> {
        Actions.nameThread("removeRenditions-" + path);
        AssetManager assetManager = (AssetManager)r.adaptTo(AssetManager.class);
        Asset asset = assetManager.getAsset(path);
        Iterator renditions = asset.listRenditions();
        while (renditions.hasNext()) {
            Rendition rendition = (Rendition)renditions.next();
            if (rendition.getName().equalsIgnoreCase("original")) continue;
            asset.removeRendition(rendition.getName());
        }
    };

    private AssetActions() {
    }

    public static final CheckedBiConsumer<ResourceResolver, String> withAllRenditions(CheckedBiConsumer<ResourceResolver, String> action, CheckedBiFunction<ResourceResolver, String, Boolean> ... filters) {
        return (r, path) -> {
            AssetManager assetManager = (AssetManager)r.adaptTo(AssetManager.class);
            Asset asset = assetManager.getAsset(path);
            Iterator renditions = asset.listRenditions();
            while (renditions.hasNext()) {
                Rendition rendition = (Rendition)renditions.next();
                boolean skip = false;
                if (filters != null) {
                    for (CheckedBiFunction filter : filters) {
                        if (((Boolean)filter.apply(r, rendition.getPath())).booleanValue()) continue;
                        skip = true;
                        break;
                    }
                }
                if (skip) continue;
                action.accept((ResourceResolver)r, (String)path);
            }
        };
    }

    public static final CheckedBiConsumer<ResourceResolver, String> removeAllRenditionsNamed(String name) {
        return (r, path) -> {
            Actions.nameThread("removeRenditions-" + path);
            AssetManager assetManager = (AssetManager)r.adaptTo(AssetManager.class);
            Asset asset = assetManager.getAsset(path);
            Iterator renditions = asset.listRenditions();
            while (renditions.hasNext()) {
                Rendition rendition = (Rendition)renditions.next();
                if (!rendition.getName().equalsIgnoreCase(name)) continue;
                asset.removeRendition(rendition.getName());
            }
        };
    }

    public static final CheckedConsumer<ResourceResolver> removeRenditions(String path) {
        return res -> REMOVE_ALL_RENDITIONS.accept((ResourceResolver)res, path);
    }

    public static final CheckedConsumer<ResourceResolver> removeRenditionsNamed(String path, String name) {
        return res -> AssetActions.removeAllRenditionsNamed(name).accept((ResourceResolver)res, path);
    }
}

