/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.models;

import com.adobe.acs.commons.redirects.filter.RedirectFilterMBean;
import com.adobe.acs.commons.redirects.models.RedirectConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.AbstractResourceVisitor;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;

@Model(adaptables={SlingHttpServletRequest.class})
public class Configurations {
    @SlingObject
    private SlingHttpServletRequest request;
    @OSGiService(injectionStrategy=InjectionStrategy.OPTIONAL)
    private RedirectFilterMBean redirectFilter;
    private static final String REDIRECTS_RESOURCE_TYPE = "acs-commons/components/utilities/manage-redirects/redirects";

    public Collection<RedirectConfiguration> getConfigurations() {
        final ArrayList<RedirectConfiguration> configurations = new ArrayList<RedirectConfiguration>();
        String bucketName = this.redirectFilter != null ? this.redirectFilter.getBucket() : "settings";
        String configName = this.redirectFilter != null ? this.redirectFilter.getConfigName() : "redirects";
        final String storageSuffix = bucketName + "/" + configName;
        Resource confRoot = this.request.getResourceResolver().getResource("/conf");
        new AbstractResourceVisitor(){

            public void accept(Resource res) {
                if (res != null) {
                    this.visit(res);
                    if (!res.getPath().endsWith(storageSuffix)) {
                        this.traverseChildren(res.listChildren());
                    }
                }
            }

            public void visit(Resource res) {
                if (res.isResourceType(Configurations.REDIRECTS_RESOURCE_TYPE)) {
                    configurations.add(new RedirectConfiguration(res, storageSuffix, false));
                }
            }
        }.accept(confRoot);
        configurations.sort(Comparator.comparing(RedirectConfiguration::getName));
        return configurations;
    }
}

