/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication.status.impl;

import com.adobe.acs.commons.replication.status.ReplicationStatusManager;
import com.adobe.acs.commons.workflow.WorkflowPackageManager;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.HashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Property(label="Workflow Label", name="process.label", value={"Set Replicated By Property to Workflow Initiator"}, description="Sets the Replicated By Property on the payload to the Workflow Initiator")
@Service
public class ReplicatedByWorkflowProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(ReplicatedByWorkflowProcess.class);
    private static final String AUTHENTICATION_INFO_SESSION = "user.jcr.session";
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private WorkflowPackageManager workflowPackageManager;
    @Reference
    private ReplicationStatusManager replStatusManager;

    public final void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        WorkflowData workflowData = workItem.getWorkflowData();
        String type = workflowData.getPayloadType();
        if (!StringUtils.equals((CharSequence)type, (CharSequence)"JCR_PATH")) {
            return;
        }
        String payloadPath = workflowData.getPayload().toString();
        HashMap<String, Session> authInfo = new HashMap<String, Session>();
        authInfo.put(AUTHENTICATION_INFO_SESSION, workflowSession.getSession());
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getResourceResolver(authInfo);){
            String replicatedBy = (String)StringUtils.defaultIfEmpty((CharSequence)workItem.getWorkflow().getInitiator(), (CharSequence)"Unknown Workflow User");
            List<String> paths = this.workflowPackageManager.getPaths(resourceResolver, payloadPath);
            for (String path : paths) {
                Resource resource = this.replStatusManager.getReplicationStatusResource(path, resourceResolver);
                ModifiableValueMap mvm = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)mvm.get("cq:lastReplicatedBy", String.class)))) {
                    mvm.put((Object)"cq:lastReplicatedBy", (Object)replicatedBy);
                    resourceResolver.commit();
                    log.trace("Set replicateBy to [ {} ] on resource  [ {} ]", (Object)replicatedBy, (Object)resource.getPath());
                    continue;
                }
                log.trace("Skipping; Resource does not have replicateBy property set  [ {} ]", (Object)resource.getPath());
            }
        }
        catch (LoginException e) {
            log.error("Could not acquire a ResourceResolver object from the Workflow Session's JCR Session: {}", (Throwable)e);
        }
        catch (PersistenceException e) {
            log.error("Could not save replicateBy property for payload [ {} ] due to: {}", (Object)payloadPath, (Object)e);
        }
        catch (RepositoryException e) {
            log.error("Could not collect Workflow Package items for payload [ {} ] due to: {}", (Object)payloadPath, (Object)e);
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindWorkflowPackageManager(WorkflowPackageManager workflowPackageManager) {
        this.workflowPackageManager = workflowPackageManager;
    }

    protected void unbindWorkflowPackageManager(WorkflowPackageManager workflowPackageManager) {
        if (this.workflowPackageManager == workflowPackageManager) {
            this.workflowPackageManager = null;
        }
    }

    protected void bindReplStatusManager(ReplicationStatusManager replicationStatusManager) {
        this.replStatusManager = replicationStatusManager;
    }

    protected void unbindReplStatusManager(ReplicationStatusManager replicationStatusManager) {
        if (this.replStatusManager == replicationStatusManager) {
            this.replStatusManager = null;
        }
    }
}

