/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication.dispatcher.impl;

import com.adobe.acs.commons.replication.dispatcher.DispatcherFlushRules;
import com.adobe.acs.commons.util.RequireAem;
import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationOptions;
import java.util.Arrays;
import java.util.List;
import org.apache.sling.discovery.DiscoveryService;
import org.apache.sling.distribution.DistributionRequestType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={EventHandler.class}, property={"event.topics=org/apache/sling/distribution/agent/package/distributed"})
public class CloudDispatcherFlushRulesExecutor
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(CloudDispatcherFlushRulesExecutor.class);
    @Reference(target="(distribution=cloud-ready)")
    private RequireAem requireAem;
    @Reference
    private DiscoveryService discoveryService;
    @Reference
    private volatile List<DispatcherFlushRules> dispatcherFlushRules;

    public void handleEvent(Event event) {
        String distributionType = (String)event.getProperty("distribution.type");
        boolean isLeader = this.discoveryService.getTopology().getLocalInstance().isLeader();
        if (isLeader) {
            String[] distributionPaths = (String[])event.getProperty("distribution.paths");
            if (distributionPaths == null || distributionPaths.length == 0) {
                log.debug("Skipping processing because the distribution paths are empty");
                return;
            }
            ReplicationActionType actionType = this.getReplicationActionType(distributionType);
            if (actionType != null) {
                this.executeFlushRules(actionType, Arrays.asList(distributionPaths));
            }
        }
    }

    private void executeFlushRules(ReplicationActionType actionType, List<String> distributionPaths) {
        ReplicationAction action = new ReplicationAction(actionType, distributionPaths.toArray(new String[0]), 0L, "", null);
        ReplicationOptions opts = new ReplicationOptions();
        log.debug("Executing dispatcher flush rules for distribution paths {}", distributionPaths);
        for (DispatcherFlushRules dispatcherFlushRule : this.dispatcherFlushRules) {
            try {
                dispatcherFlushRule.preprocess(action, opts);
            }
            catch (ReplicationException e) {
                log.warn("Could not execute dispatcher flush rule for distribution paths [{}]", distributionPaths, (Object)e);
            }
        }
        if (log.isInfoEnabled()) {
            log.info("Executed flush rules for resources [{}]", distributionPaths);
        }
    }

    private ReplicationActionType getReplicationActionType(String distributionType) {
        DistributionRequestType requestType = DistributionRequestType.fromName((String)distributionType);
        if (DistributionRequestType.ADD.equals((Object)requestType)) {
            return ReplicationActionType.ACTIVATE;
        }
        if (DistributionRequestType.DELETE.equals((Object)requestType)) {
            return ReplicationActionType.DEACTIVATE;
        }
        if (DistributionRequestType.TEST.equals((Object)requestType)) {
            return ReplicationActionType.TEST;
        }
        log.debug("Distribution request type {} not supported", (Object)requestType);
        return null;
    }
}

