/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.contentsync;

import com.adobe.acs.commons.contentsync.SyncHostConfiguration;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class RemoteInstance
implements Closeable {
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int SOCKET_TIMEOUT = 60000;
    private final CloseableHttpClient httpClient;
    private final SyncHostConfiguration hostConfiguration;

    public RemoteInstance(SyncHostConfiguration hostConfiguration) {
        this.hostConfiguration = hostConfiguration;
        this.httpClient = this.createHttpClient();
    }

    private CloseableHttpClient createHttpClient() {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.hostConfiguration.getUsername(), this.hostConfiguration.getPassword()));
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(60000).setCookieSpec("standard").build();
        return HttpClients.custom().setDefaultRequestConfig(requestConfig).setDefaultCredentialsProvider((CredentialsProvider)provider).build();
    }

    public InputStream getStream(String path) throws IOException, URISyntaxException {
        URI uri = this.toURI(path, new String[0]);
        return this.getStream(uri);
    }

    public InputStream getStream(URI uri) throws IOException {
        HttpGet request = new HttpGet(uri);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
        switch (response.getStatusLine().getStatusCode()) {
            case 200: {
                return response.getEntity().getContent();
            }
            case 300: {
                String msg = this.formatError(uri.toString(), response.getStatusLine().getStatusCode(), "It seems that the \"Json Max Results\" in Sling Get Servlet is too low. Increase it to a higher value, e.g. 1000.");
                throw new IOException(msg);
            }
        }
        String msg = this.formatError(uri.toString(), response.getStatusLine().getStatusCode(), "Response: " + EntityUtils.toString((HttpEntity)response.getEntity()));
        throw new IOException(msg);
    }

    public String getString(URI uri) throws IOException {
        HttpGet request = new HttpGet(uri);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);){
            String str = EntityUtils.toString((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() == 200) {
                String string = str;
                return string;
            }
            String msg = this.formatError(uri.toString(), response.getStatusLine().getStatusCode(), "Response: " + str);
            throw new IOException(msg);
        }
    }

    private String formatError(String uri, int statusCode, String message) {
        return String.format("Failed to fetch data from %s, HTTP [%d]%n%s", uri, statusCode, message);
    }

    public String getPrimaryType(String path) throws IOException, URISyntaxException {
        URI uri = this.toURI(path + "/" + "jcr:primaryType", new String[0]);
        String str = this.getString(uri);
        if (str.isEmpty()) {
            throw new IllegalStateException("It appears " + this.hostConfiguration.getUsername() + " user does not have permissions to read " + uri);
        }
        return str;
    }

    public List<String> listChildren(String path) throws IOException, URISyntaxException {
        List<String> children;
        try (InputStream is = this.getStream(path + ".1.json");
             JsonReader reader = Json.createReader((InputStream)is);){
            children = reader.readObject().entrySet().stream().filter(entry -> ((JsonValue)entry.getValue()).getValueType() == JsonValue.ValueType.OBJECT).map(Map.Entry::getKey).collect(Collectors.toList());
        }
        return children;
    }

    public JsonObject getJson(String path, String ... parameters) throws IOException, URISyntaxException {
        URI uri = this.toURI(path, parameters);
        return this.getJson(uri);
    }

    public JsonObject getJson(URI uri) throws IOException {
        try (InputStream is = this.getStream(uri);){
            JsonObject jsonObject;
            block12: {
                JsonReader reader = Json.createReader((InputStream)is);
                try {
                    jsonObject = reader.readObject();
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return jsonObject;
        }
    }

    URI toURI(String path, String ... parameters) throws URISyntaxException {
        URIBuilder ub = new URIBuilder(this.hostConfiguration.getHost()).setPath(path);
        if (parameters != null) {
            if (parameters.length % 2 != 0) {
                throw new IllegalArgumentException("query string parameters must be an even number of name/values:" + Arrays.asList(parameters));
            }
            for (int i = 0; i < parameters.length; i += 2) {
                ub.addParameter(parameters[i], parameters[i + 1]);
            }
        }
        return ub.build();
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }
}

