/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes.cfi;

import com.adobe.acs.commons.data.CompositeVariant;
import com.adobe.acs.commons.data.Spreadsheet;
import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.actions.Actions;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.CheckboxComponent;
import com.adobe.acs.commons.mcp.form.FileUploadComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.model.GenericReport;
import com.adobe.cq.dam.cfm.ContentElement;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.FragmentTemplate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class ContentFragmentImport
extends ProcessDefinition {
    List<EnumMap<ReportColumns, Object>> reportRows = new ArrayList<EnumMap<ReportColumns, Object>>();
    EnumMap<ReportColumns, Object> createdFolders = this.trackActivity("All folders", "Create", "Count of all folders created");
    EnumMap<ReportColumns, Object> importedFragments = this.trackActivity("Fragments", "Import", "Count of all imported fragments");
    EnumMap<ReportColumns, Object> skippedFragments = this.trackActivity("Fragments", "Skipped", "Count of skipped fragments");
    public static final String PATH = "path";
    public static final String FOLDER_TITLE = "folderTitle";
    public static final String NAME = "name";
    public static final String TITLE = "title";
    public static final String TEMPLATE = "template";
    public static final String DEFAULT_FOLDER_TYPE = "sling:Folder";
    @FormField(name="Fragment data", component=FileUploadComponent.class)
    transient RequestParameter importFile;
    transient Spreadsheet spreadsheet;
    @FormField(name="Dry run", component=CheckboxComponent.class, options={"checked"})
    transient boolean dryRunMode = true;
    @FormField(name="Detailed Report", component=CheckboxComponent.class, options={"checked"})
    transient boolean detailedReport = true;

    @Override
    public void init() throws RepositoryException {
        try {
            this.spreadsheet = new Spreadsheet(this.importFile, PATH, TEMPLATE, NAME, TITLE).buildSpreadsheet();
        }
        catch (IOException ex) {
            throw new RepositoryException("Unable to process spreadsheet", (Throwable)ex);
        }
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException, RepositoryException {
        instance.defineCriticalAction("Create folders", rr, this::createFolders);
        instance.defineCriticalAction("Import fragments", rr, this::importFragments);
    }

    @Override
    public void storeReport(ProcessInstance instance, ResourceResolver rr) throws RepositoryException, PersistenceException {
        GenericReport report = new GenericReport();
        report.setRows(this.reportRows, ReportColumns.class);
        report.persist(rr, instance.getPath() + "/jcr:content/report");
    }

    private synchronized EnumMap<ReportColumns, Object> trackActivity(String item, String action, String description) {
        if (this.reportRows == null) {
            this.reportRows = Collections.synchronizedList(new ArrayList());
        }
        EnumMap<ReportColumns, Object> reportRow = new EnumMap<ReportColumns, Object>(ReportColumns.class);
        reportRow.put(ReportColumns.ITEM, item);
        reportRow.put(ReportColumns.ACTION, action);
        reportRow.put(ReportColumns.DESCRIPTION, description);
        reportRow.put(ReportColumns.COUNT, Long.valueOf(0L));
        this.reportRows.add(reportRow);
        return reportRow;
    }

    protected synchronized EnumMap<ReportColumns, Object> trackDetailedActivity(String item, String action, String description, Long bytes) {
        if (this.detailedReport) {
            return this.trackActivity(item, action, description);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increment(EnumMap<ReportColumns, Object> row, ReportColumns col, long amt) {
        if (row != null) {
            EnumMap<ReportColumns, Object> enumMap = row;
            synchronized (enumMap) {
                row.put(col, (Object)((Long)row.getOrDefault((Object)col, 0) + amt));
            }
        }
    }

    protected void incrementCount(EnumMap<ReportColumns, Object> row, long amt) {
        this.increment(row, ReportColumns.COUNT, amt);
    }

    protected void createFolders(ActionManager manager) throws IOException {
        manager.deferredWithResolver(r -> {
            TreeMap folders = new TreeMap();
            this.spreadsheet.getDataRowsAsCompositeVariants().forEach(row -> {
                String path = this.getString((Map<String, CompositeVariant>)row, PATH);
                String folderTitle = this.getString((Map<String, CompositeVariant>)row, FOLDER_TITLE);
                if (!folders.containsKey(path)) {
                    folders.put(path, folderTitle);
                    manager.deferredWithResolver(Actions.retry(10, 100L, rr -> {
                        manager.setCurrentItem(path);
                        this.createFolderNode(path, folderTitle, (ResourceResolver)rr);
                    }));
                }
            });
        });
    }

    protected boolean createFolderNode(String path, String folderTitle, ResourceResolver r) throws RepositoryException, PersistenceException {
        boolean titleProvided;
        if (path == null) {
            return false;
        }
        if (this.dryRunMode) {
            return true;
        }
        String parentPath = StringUtils.substringBeforeLast((String)path, (String)"/");
        String folderName = StringUtils.substringAfterLast((String)path, (String)"/");
        if (folderTitle == null) {
            folderTitle = folderName;
            titleProvided = false;
        } else {
            titleProvided = true;
        }
        Session s = (Session)r.adaptTo(Session.class);
        if (s.nodeExists(path) && titleProvided) {
            return this.updateFolderTitle(s, path, folderTitle, r);
        }
        if (!s.nodeExists(path)) {
            if (!s.nodeExists(parentPath)) {
                this.createFolderNode(parentPath, null, r);
            }
            Node child = s.getNode(parentPath).addNode(folderName, DEFAULT_FOLDER_TYPE);
            this.trackDetailedActivity(path, "Create Folder", "Create folder", 0L);
            this.setFolderTitle(child, folderTitle);
            this.incrementCount(this.createdFolders, 1L);
            r.commit();
            r.refresh();
            return true;
        }
        return false;
    }

    private boolean updateFolderTitle(Session s, String path, String folderTitle, ResourceResolver r) throws PersistenceException, RepositoryException {
        Node folderContentNode;
        Node folderNode = s.getNode(path);
        Node node = folderContentNode = folderNode.hasNode("jcr:content") ? folderNode.getNode("jcr:content") : null;
        if (null != folderContentNode && folderContentNode.hasProperty("jcr:title") && folderContentNode.getProperty("jcr:title").getString().equals(folderTitle)) {
            return false;
        }
        if (folderContentNode == null) {
            folderContentNode = folderNode.addNode("jcr:content", "nt:unstructured");
        }
        folderContentNode.setProperty("jcr:title", folderTitle);
        r.commit();
        r.refresh();
        return true;
    }

    private void setFolderTitle(Node child, String title) throws RepositoryException {
        if (child.hasNode("jcr:content")) {
            child.getNode("jcr:content").setProperty("jcr:title", title);
        } else {
            child.addNode("jcr:content", "nt:unstructured").setProperty("jcr:title", title);
        }
    }

    protected void importFragments(ActionManager manager) throws IOException {
        manager.deferredWithResolver(r -> this.spreadsheet.getDataRowsAsCompositeVariants().forEach(row -> manager.deferredWithResolver(rr -> this.importFragment((ResourceResolver)rr, (Map<String, CompositeVariant>)row))));
    }

    private void importFragment(ResourceResolver rr, Map<String, CompositeVariant> row) throws ContentFragmentException, PersistenceException {
        boolean created;
        String name = this.getString(row, NAME);
        String title = this.getString(row, TITLE);
        String path = this.getString(row, PATH);
        String template = this.getString(row, TEMPLATE);
        Resource templateResource = this.getFragmentTemplateResource(rr, template);
        if (templateResource == null) {
            throw new ContentFragmentException("Unable to locate template " + template);
        }
        if (this.dryRunMode) {
            created = rr.getResource(path + "/" + name) == null;
        } else {
            ContentFragment cf = this.getOrCreateFragment(rr.getResource(path), templateResource, name, title);
            created = rr.hasChanges();
            this.setContentElements(cf, row);
            this.setAssetMetadata(row, cf);
            if (rr.hasChanges()) {
                this.incrementCount(this.importedFragments, 1L);
                rr.commit();
            } else {
                this.incrementCount(this.skippedFragments, 1L);
            }
        }
        if (this.detailedReport) {
            if (created) {
                this.trackDetailedActivity("Created Fragment", path, "Created fragment " + name, 0L);
            } else if (rr.hasChanges()) {
                this.trackDetailedActivity("Updated Fragment", path, "Updated existing fragment " + name, 0L);
            }
        }
    }

    private void setAssetMetadata(Map<String, CompositeVariant> row, ContentFragment cf) throws ContentFragmentException {
        for (Map.Entry<String, CompositeVariant> col : row.entrySet()) {
            if (!col.getKey().contains(":") || col.getValue() == null) continue;
            if (col.getValue().isArray()) {
                cf.setMetaData(col.getKey(), (Object)col.getValue().getValues().toArray());
                continue;
            }
            cf.setMetaData(col.getKey(), (Object)col.getValue().getValueAs(String.class));
        }
    }

    private void setContentElements(ContentFragment cf, Map<String, CompositeVariant> row) throws ContentFragmentException {
        Iterator i = cf.getElements();
        while (i.hasNext()) {
            ContentElement contentElement = (ContentElement)i.next();
            String value = this.getString(row, contentElement);
            String currentValue = contentElement.getContent();
            String contentType = StringUtils.isBlank((String)currentValue) ? cf.getTemplate().getForElement(contentElement).getInitialContentType() : contentElement.getContentType();
            if (String.valueOf(value).equals(String.valueOf(currentValue))) continue;
            contentElement.setContent(value, contentType);
        }
    }

    private String getString(Map<String, CompositeVariant> row, String attr) {
        CompositeVariant v = row.get(attr.toLowerCase());
        if (v != null) {
            return v.getValueAs(String.class);
        }
        return null;
    }

    private String getString(Map<String, CompositeVariant> row, ContentElement contentElement) {
        String elementName = contentElement.getName();
        String dataType = contentElement.getValue().getDataType().getTypeString();
        CompositeVariant v = row.get(elementName.toLowerCase());
        if (v != null) {
            Object value = v.getValue();
            if (value instanceof Calendar && dataType.matches("date|calendar")) {
                long timestamp = ((Calendar)value).getTimeInMillis();
                return String.valueOf(timestamp);
            }
            if (value instanceof Date && dataType.matches("date|calendar")) {
                long timestamp = ((Date)value).getTime();
                return String.valueOf(timestamp);
            }
            return v.getValueAs(String.class);
        }
        return null;
    }

    protected ContentFragment getOrCreateFragment(Resource parent, Resource template, String name, String title) throws ContentFragmentException {
        Resource fragmentResource = parent.getChild(name);
        if (fragmentResource == null) {
            FragmentTemplate fragmentTemplate = (FragmentTemplate)template.adaptTo(FragmentTemplate.class);
            return fragmentTemplate.createFragment(parent, name, title);
        }
        return (ContentFragment)fragmentResource.adaptTo(ContentFragment.class);
    }

    protected Resource getFragmentTemplateResource(ResourceResolver rr, String templatePath) {
        Resource template = rr.resolve(templatePath);
        if (template.adaptTo(FragmentTemplate.class) != null) {
            return template;
        }
        return template.getChild("jcr:content");
    }

    public static enum ReportColumns {
        ITEM,
        ACTION,
        DESCRIPTION,
        COUNT;

    }
}

