/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.util;

import com.adobe.acs.commons.mcp.util.IntrospectionUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueMapSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(ValueMapSerializer.class);

    public static void serializeToResource(Resource r, Object sourceObject) {
        Map map = (Map)r.adaptTo(ModifiableValueMap.class);
        if (map == null) {
            LOG.error("Unable to get modifiable value map for resource {}", (Object)r.getPath());
        } else {
            ValueMapSerializer.serializeToMap(map, sourceObject);
        }
    }

    public static void serializeToMap(Map<String, Object> map, Object sourceObject) {
        if (sourceObject == null) {
            return;
        }
        FieldUtils.getAllFieldsList(sourceObject.getClass()).stream().filter(IntrospectionUtil::isSimple).forEach(f -> {
            try {
                Object value = FieldUtils.readField((Field)f, (Object)sourceObject, (boolean)true);
                if (value != null) {
                    map.put(f.getName(), value);
                }
            }
            catch (IllegalAccessException ex) {
                LOG.error("Exception while serializing", (Throwable)ex);
            }
        });
    }

    public static String[] serializeToStringArray(Object value) {
        if (value == null) {
            return new String[0];
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value.getClass().isArray()) {
            List<String> values = Arrays.asList((Object[])value).stream().map(String::valueOf).collect(Collectors.toList());
            return values.toArray(new String[0]);
        }
        if (value instanceof Collection) {
            List<String> values = ((Collection)value).stream().map(String::valueOf).collect(Collectors.toList());
            return values.toArray(new String[0]);
        }
        return new String[]{value.toString()};
    }

    private ValueMapSerializer() {
    }
}

