/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.version.impl;

import com.adobe.acs.commons.version.Evolution;
import com.adobe.acs.commons.version.EvolutionEntry;
import com.adobe.acs.commons.version.impl.EvolutionConfig;
import com.adobe.acs.commons.version.impl.EvolutionEntryImpl;
import com.adobe.acs.commons.version.impl.EvolutionPathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EvolutionImpl
implements Evolution {
    private static final Logger log = LoggerFactory.getLogger(EvolutionImpl.class);
    private final List<EvolutionEntry> versionEntries = new ArrayList<EvolutionEntry>();
    private final Resource versionResource;
    private final Version version;
    private final EvolutionConfig config;

    public EvolutionImpl(Version version, Resource resource, EvolutionConfig config) {
        this.version = version;
        this.config = config;
        this.versionResource = resource;
        try {
            this.populate(this.versionResource, 0);
        }
        catch (Exception e) {
            log.warn("Could not populate Evolution", (Throwable)e);
        }
    }

    @Override
    public List<EvolutionEntry> getVersionEntries() {
        return Collections.unmodifiableList(this.versionEntries);
    }

    @Override
    public Date getVersionDate() {
        try {
            return this.version.getCreated().getTime();
        }
        catch (RepositoryException e) {
            log.warn("Could not get created date from version", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getVersionName() {
        try {
            return this.version.getName();
        }
        catch (RepositoryException e) {
            log.warn("Could not determine version name");
            return "null";
        }
    }

    @Override
    public boolean isCurrent() {
        try {
            Version[] successors = this.version.getSuccessors();
            if (successors == null || successors.length == 0) {
                return true;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public Resource getResource() {
        return this.versionResource;
    }

    public ValueMap getProperties() {
        return this.versionResource.getValueMap();
    }

    private void populate(Resource r, int depth) throws PathNotFoundException, RepositoryException {
        ValueMap map = r.getValueMap();
        ArrayList keys = new ArrayList(map.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            Property property = ((Node)r.adaptTo(Node.class)).getProperty(key);
            String relPath = EvolutionPathUtil.getRelativePropertyName(property.getPath());
            if (!this.config.handleProperty(relPath)) continue;
            this.versionEntries.add(new EvolutionEntryImpl(property, this.version, this.config));
        }
        Iterator iter = r.getChildren().iterator();
        while (iter.hasNext()) {
            ++depth;
            Resource child = (Resource)iter.next();
            String relPath = EvolutionPathUtil.getRelativeResourceName(child.getPath());
            if (this.config.handleResource(relPath)) {
                this.versionEntries.add(new EvolutionEntryImpl(child, this.version, this.config));
                this.populate(child, depth);
            }
            --depth;
        }
    }
}

