/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.execution.model;

import com.adobe.acs.commons.workflow.bulk.execution.BulkWorkflowRunner;
import com.adobe.acs.commons.workflow.bulk.execution.model.Config;
import com.adobe.acs.commons.workflow.bulk.execution.model.Failure;
import com.adobe.acs.commons.workflow.bulk.execution.model.Payload;
import com.adobe.acs.commons.workflow.bulk.execution.model.PayloadGroup;
import com.adobe.acs.commons.workflow.bulk.execution.model.Status;
import com.adobe.acs.commons.workflow.bulk.execution.model.SubStatus;
import com.day.cq.commons.jcr.JcrUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;

@Model(adaptables={Resource.class})
public class Workspace {
    public static final String NT_UNORDERED = "oak:Unstructured";
    public static final String NN_FAILURES = "failures";
    public static final String NN_FAILURE = "failure";
    public static final String NN_WORKSPACE = "workspace";
    public static final String NN_PAYLOADS = "payloads";
    public static final String PN_ACTIVE_PAYLOAD_GROUPS = "activePayloadGroups";
    public static final String PN_ACTIVE_PAYLOADS = "activePayloads";
    public static final String PN_STATUS = "status";
    public static final String PN_SUB_STATUS = "subStatus";
    private static final String PN_INITIALIZED = "initialized";
    private static final String PN_COMPLETED_AT = "completedAt";
    private static final String PN_COUNT_COMPLETE = "completeCount";
    private static final String PN_COUNT_FAILURE = "failCount";
    private static final String PN_COUNT_TOTAL = "totalCount";
    private static final String PN_STARTED_AT = "startedAt";
    private static final String PN_STOPPED_AT = "stoppedAt";
    private static final String PN_MESSAGE = "message";
    private static final String PN_ACTION_MANAGER_NAME = "actionManagerName";
    public static final String NN_PAYLOADS_LAUNCHPAD = "payloads_zero";
    private Resource resource;
    private ModifiableValueMap properties;
    private BulkWorkflowRunner runner;
    private Config config;
    @Inject
    private List<BulkWorkflowRunner> runners;
    @Inject
    @Optional
    private String jobName;
    @Inject
    private ResourceResolver resourceResolver;
    @Inject
    @Default(values={})
    private String[] activePayloads;
    @Inject
    @Default(values={})
    private String[] activePayloadGroups;
    @Inject
    @Default(values={"NOT_STARTED"})
    private String status;
    @Inject
    @Optional
    private String subStatus;
    @Inject
    @Default(booleanValues={false})
    private boolean initialized;
    @Inject
    @Default(intValues={0})
    private int totalCount;
    @Inject
    @Default(intValues={0})
    private int completeCount;
    @Inject
    @Default(intValues={0})
    private int failCount;
    @Inject
    @Optional
    private Calendar startedAt;
    @Inject
    @Optional
    private Calendar stoppedAt;
    @Inject
    @Optional
    private Calendar completedAt;
    @Inject
    @Optional
    private String message;
    @Inject
    private List<Failure> failures;
    @Inject
    @Optional
    private String actionManagerName;

    public Workspace(Resource resource) {
        this.resource = resource;
        this.properties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        this.jobName = "acs-commons@bulk-workflow-execution:/" + this.resource.getPath();
    }

    @PostConstruct
    protected void activate() {
        this.config = (Config)this.resource.getParent().adaptTo(Config.class);
        for (BulkWorkflowRunner candidate : this.runners) {
            if (!StringUtils.equals((String)this.config.getRunnerType(), (String)candidate.getClass().getName())) continue;
            this.runner = candidate;
            break;
        }
    }

    public Calendar getCompletedAt() {
        return this.completedAt;
    }

    public void setCompletedAt(Calendar completedAt) {
        this.completedAt = completedAt;
        this.properties.put((Object)PN_COMPLETED_AT, (Object)this.completedAt);
    }

    public int getCompleteCount() {
        return this.completeCount;
    }

    public int getFailCount() {
        return this.failCount;
    }

    public String getJobName() {
        return this.jobName;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
        this.properties.put((Object)PN_COUNT_TOTAL, (Object)this.totalCount);
    }

    public BulkWorkflowRunner getRunner() {
        return this.runner;
    }

    public Calendar getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(Calendar startedAt) {
        this.startedAt = startedAt;
        this.properties.put((Object)PN_STARTED_AT, (Object)this.startedAt);
    }

    public Status getStatus() {
        this.resourceResolver.refresh();
        this.status = (String)this.resource.getValueMap().get(PN_STATUS, (Object)Status.NOT_STARTED.toString());
        return (Status)EnumUtils.getEnum(Status.class, (String)this.status);
    }

    public Calendar getStoppedAt() {
        return this.stoppedAt;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isRunning() {
        return Status.RUNNING.equals((Object)this.getStatus());
    }

    public boolean isStopped() {
        return Status.STOPPED.equals((Object)this.getStatus());
    }

    public boolean isStopping() {
        return Status.RUNNING.equals((Object)this.getStatus()) && SubStatus.STOPPING.equals((Object)this.getSubStatus());
    }

    public Config getConfig() {
        return this.config;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public boolean isActive(PayloadGroup payloadGroup) {
        return ArrayUtils.contains((Object[])this.activePayloadGroups, (Object)payloadGroup.getDereferencedPath());
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public String getMessage() {
        return this.message;
    }

    public String getActionManagerName() {
        return this.actionManagerName;
    }

    public List<Failure> getFailures() {
        return Collections.unmodifiableList(this.failures);
    }

    public void setStatus(Status status) {
        this.status = status.toString();
        this.properties.put((Object)PN_STATUS, (Object)this.status);
        this.subStatus = null;
        this.properties.remove((Object)PN_SUB_STATUS);
    }

    public void setStatus(Status status, SubStatus subStatus) {
        this.setStatus(status);
        if (subStatus != null) {
            this.subStatus = subStatus.toString();
            this.properties.put((Object)PN_SUB_STATUS, (Object)this.subStatus);
        }
    }

    public SubStatus getSubStatus() {
        this.resourceResolver.refresh();
        this.subStatus = (String)this.resource.getValueMap().get(PN_SUB_STATUS, String.class);
        if (this.subStatus != null) {
            return (SubStatus)EnumUtils.getEnum(SubStatus.class, (String)this.subStatus);
        }
        return null;
    }

    public void setStoppedAt(Calendar stoppedAt) {
        this.stoppedAt = stoppedAt;
        this.properties.put((Object)PN_STOPPED_AT, (Object)this.stoppedAt);
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
        this.properties.put((Object)PN_INITIALIZED, (Object)this.initialized);
    }

    public int incrementCompleteCount() {
        this.setCompleteCount(this.completeCount + 1);
        return this.completeCount;
    }

    public int setCompleteCount(int count) {
        this.completeCount = count;
        this.properties.put((Object)PN_COUNT_COMPLETE, (Object)count);
        return this.completeCount;
    }

    public int incrementFailCount() {
        this.setFailureCount(this.failCount + 1);
        return this.failCount;
    }

    public int setFailureCount(int count) {
        this.failCount = count;
        this.properties.put((Object)PN_COUNT_FAILURE, (Object)count);
        return this.failCount;
    }

    public void setError(String message) {
        this.setStatus(Status.STOPPED, SubStatus.ERROR);
        this.setMessage(message);
    }

    public void setMessage(String message) {
        this.message = message;
        this.properties.put((Object)PN_MESSAGE, (Object)message);
    }

    public void setActionManagerName(String name) {
        this.actionManagerName = name;
        this.properties.put((Object)PN_ACTION_MANAGER_NAME, (Object)name);
    }

    public void addActivePayload(Payload payload) {
        if (!ArrayUtils.contains((Object[])this.activePayloads, (Object)payload.getDereferencedPath())) {
            this.activePayloads = (String[])ArrayUtils.add((Object[])this.activePayloads, (Object)payload.getDereferencedPath());
            this.properties.put((Object)PN_ACTIVE_PAYLOADS, (Object)this.activePayloads);
            this.addActivePayloadGroup(payload.getPayloadGroup());
        }
    }

    public void addActivePayloads(List<Payload> payloads) {
        for (Payload payload : payloads) {
            this.addActivePayload(payload);
        }
    }

    public void removeActivePayload(Payload payload) {
        if (ArrayUtils.contains((Object[])this.activePayloads, (Object)payload.getDereferencedPath())) {
            this.activePayloads = (String[])ArrayUtils.removeElement((Object[])this.activePayloads, (Object)payload.getDereferencedPath());
            this.properties.put((Object)PN_ACTIVE_PAYLOADS, (Object)this.activePayloads);
        }
    }

    public List<Payload> getActivePayloads() {
        ArrayList<Payload> payloads = new ArrayList<Payload>();
        for (String path : this.activePayloads) {
            Payload p;
            Resource r = this.resourceResolver.getResource(Payload.reference(path));
            if (r == null || (p = (Payload)r.adaptTo(Payload.class)) == null) continue;
            payloads.add(p);
        }
        return payloads;
    }

    public List<PayloadGroup> getActivePayloadGroups() {
        ArrayList<PayloadGroup> payloadGroups = new ArrayList<PayloadGroup>();
        if (this.activePayloadGroups != null) {
            for (String path : this.activePayloadGroups) {
                PayloadGroup pg;
                Resource r = this.resourceResolver.getResource(PayloadGroup.reference(path));
                if (r == null || (pg = (PayloadGroup)r.adaptTo(PayloadGroup.class)) == null) continue;
                payloadGroups.add(pg);
            }
        }
        return payloadGroups;
    }

    public void addActivePayloadGroup(PayloadGroup payloadGroup) {
        if (payloadGroup != null && !ArrayUtils.contains((Object[])this.activePayloadGroups, (Object)payloadGroup.getDereferencedPath())) {
            this.activePayloadGroups = (String[])ArrayUtils.add((Object[])this.activePayloadGroups, (Object)payloadGroup.getDereferencedPath());
            this.properties.put((Object)PN_ACTIVE_PAYLOAD_GROUPS, (Object)this.activePayloadGroups);
        }
    }

    public void removeActivePayloadGroup(PayloadGroup payloadGroup) {
        if (payloadGroup != null && ArrayUtils.contains((Object[])this.activePayloadGroups, (Object)payloadGroup.getDereferencedPath())) {
            this.activePayloadGroups = (String[])ArrayUtils.removeElement((Object[])this.activePayloadGroups, (Object)payloadGroup.getDereferencedPath());
            this.properties.put((Object)PN_ACTIVE_PAYLOAD_GROUPS, (Object)this.activePayloadGroups);
        }
    }

    public void addFailure(Payload payload) throws RepositoryException {
        this.addFailure(payload.getDereferencedPayloadPath(), payload.getDereferencedPath(), Calendar.getInstance());
    }

    public void addFailure(String payloadPath, String trackPath, Calendar failedAt) throws RepositoryException {
        Node failure = JcrUtils.getOrCreateByPath((Node)((Node)this.resource.getChild(NN_FAILURES).adaptTo(Node.class)), (String)NN_FAILURE, (boolean)true, (String)NT_UNORDERED, (String)NT_UNORDERED, (boolean)false);
        JcrUtil.setProperty((Node)failure, (String)"payloadPath", (Object)payloadPath);
        if (StringUtils.isNotBlank((String)trackPath)) {
            JcrUtil.setProperty((Node)failure, (String)"path", (Object)Payload.dereference(trackPath));
        }
        if (failedAt != null) {
            JcrUtil.setProperty((Node)failure, (String)"failedAt", (Object)failedAt);
        }
    }

    public void commit() throws PersistenceException {
        this.config.commit();
    }
}

