/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.process.impl;

import com.adobe.acs.commons.fam.ThrottledTaskRunner;
import com.adobe.acs.commons.replication.AgentIdsAgentFilter;
import com.adobe.acs.commons.replication.BrandPortalAgentFilter;
import com.adobe.acs.commons.util.ParameterUtil;
import com.adobe.acs.commons.util.WorkflowHelper;
import com.adobe.acs.commons.util.visitors.ContentVisitor;
import com.adobe.acs.commons.util.visitors.ResourceRunnable;
import com.adobe.acs.commons.workflow.WorkflowPackageManager;
import com.day.cq.replication.AgentFilter;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.Replicator;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="ACS AEM Commons - Workflow Process - Replicate with Options", description="Replicates the content based on the process arg replication configuration using FAM,")
@Properties(value={@Property(label="Workflow Label", name="process.label", value={"Replicate with Options"}, description="Replicates the content based on the process arg replication configuration (serial execution)")})
@Service
public class ReplicateWithOptionsWorkflowProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(ReplicateWithOptionsWorkflowProcess.class);
    private static final String ARG_TRAVERSE_TREE = "traverseTree";
    private static final String ARG_REPLICATION_ACTION_TYPE = "replicationActionType";
    private static final String ARG_REPLICATION_SYNCHRONOUS = "synchronous";
    private static final String ARG_REPLICATION_SUPPRESS_STATUS_UPDATE = "suppressStatusUpdate";
    private static final String ARG_REPLICATION_SUPPRESS_VERSIONS = "suppressVersions";
    private static final String ARG_THROTTLE = "throttle";
    private static final String ARG_AGENTS = "agents";
    private static final String BRAND_PORTAL_AGENTS = "BRAND_PORTAL_AGENTS";
    @Reference
    private WorkflowPackageManager workflowPackageManager;
    @Reference
    private Replicator replicator;
    @Reference
    private ThrottledTaskRunner throttledTaskRunner;
    @Reference
    private WorkflowHelper workflowHelper;

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        ResourceResolver resourceResolver = null;
        long start = System.currentTimeMillis();
        try {
            resourceResolver = this.workflowHelper.getResourceResolver(workflowSession);
            String originalPayload = (String)workItem.getWorkflowData().getPayload();
            List<String> payloads = this.workflowPackageManager.getPaths(resourceResolver, originalPayload);
            final ProcessArgs processArgs = new ProcessArgs(metaDataMap);
            final AtomicInteger count = new AtomicInteger(0);
            ResourceRunnable replicatorRunnable = new ResourceRunnable(){

                @Override
                public void run(Resource resource) throws Exception {
                    if (processArgs.isThrottle()) {
                        ReplicateWithOptionsWorkflowProcess.this.throttledTaskRunner.waitForLowCpuAndLowMemory();
                    }
                    ReplicateWithOptionsWorkflowProcess.this.replicator.replicate((Session)resource.getResourceResolver().adaptTo(Session.class), processArgs.getReplicationActionType(), resource.getPath(), processArgs.getReplicationOptions(resource));
                    count.incrementAndGet();
                }
            };
            ContentVisitor<1> visitor = new ContentVisitor<1>(replicatorRunnable);
            for (String payload : payloads) {
                Resource resource = resourceResolver.getResource(payload);
                if (processArgs.isTraverseTree()) {
                    visitor.accept(resource);
                    continue;
                }
                replicatorRunnable.run(resource);
            }
            log.info("Replicate with Options processed [ {} ] total payloads in {} ms", (Object)count.get(), (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    protected void bindWorkflowPackageManager(WorkflowPackageManager workflowPackageManager) {
        this.workflowPackageManager = workflowPackageManager;
    }

    protected void unbindWorkflowPackageManager(WorkflowPackageManager workflowPackageManager) {
        if (this.workflowPackageManager == workflowPackageManager) {
            this.workflowPackageManager = null;
        }
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }

    protected void bindThrottledTaskRunner(ThrottledTaskRunner throttledTaskRunner) {
        this.throttledTaskRunner = throttledTaskRunner;
    }

    protected void unbindThrottledTaskRunner(ThrottledTaskRunner throttledTaskRunner) {
        if (this.throttledTaskRunner == throttledTaskRunner) {
            this.throttledTaskRunner = null;
        }
    }

    protected void bindWorkflowHelper(WorkflowHelper workflowHelper) {
        this.workflowHelper = workflowHelper;
    }

    protected void unbindWorkflowHelper(WorkflowHelper workflowHelper) {
        if (this.workflowHelper == workflowHelper) {
            this.workflowHelper = null;
        }
    }

    protected static class ProcessArgs {
        private ReplicationActionType replicationActionType;
        private ReplicationOptions replicationOptions = new ReplicationOptions();
        private boolean traverseTree;
        private boolean throttle;
        private List<String> agents;

        public ProcessArgs(MetaDataMap map) throws WorkflowException {
            String[] lines = StringUtils.split((String)((String)map.get("PROCESS_ARGS", (Object)"")), (String)System.lineSeparator());
            Map<String, String> data = ParameterUtil.toMap(lines, "=");
            this.throttle = Boolean.parseBoolean(data.get(ReplicateWithOptionsWorkflowProcess.ARG_THROTTLE));
            this.traverseTree = Boolean.parseBoolean(data.get(ReplicateWithOptionsWorkflowProcess.ARG_TRAVERSE_TREE));
            this.replicationActionType = ReplicationActionType.fromName((String)data.get(ReplicateWithOptionsWorkflowProcess.ARG_REPLICATION_ACTION_TYPE));
            if (this.replicationActionType == null) {
                throw new WorkflowException("Unable to parse the replicationActionType from the Workflow Process Args");
            }
            this.replicationOptions.setSynchronous(Boolean.parseBoolean(data.get(ReplicateWithOptionsWorkflowProcess.ARG_REPLICATION_SYNCHRONOUS)));
            this.replicationOptions.setSuppressVersions(Boolean.parseBoolean(data.get(ReplicateWithOptionsWorkflowProcess.ARG_REPLICATION_SUPPRESS_VERSIONS)));
            this.replicationOptions.setSuppressStatusUpdate(Boolean.parseBoolean(data.get(ReplicateWithOptionsWorkflowProcess.ARG_REPLICATION_SUPPRESS_STATUS_UPDATE)));
            this.agents = Arrays.asList(StringUtils.split((String)data.get(ReplicateWithOptionsWorkflowProcess.ARG_AGENTS), (String)","));
        }

        public ReplicationActionType getReplicationActionType() {
            return this.replicationActionType;
        }

        public ReplicationOptions getReplicationOptions(Resource content) {
            if (this.agents.size() == 1 && ReplicateWithOptionsWorkflowProcess.BRAND_PORTAL_AGENTS.equals(this.agents.get(0))) {
                this.replicationOptions.setFilter((AgentFilter)new BrandPortalAgentFilter(content));
            } else {
                this.replicationOptions.setFilter((AgentFilter)new AgentIdsAgentFilter(this.agents));
            }
            return this.replicationOptions;
        }

        public boolean isTraverseTree() {
            return this.traverseTree;
        }

        public boolean isThrottle() {
            return this.throttle;
        }
    }
}

