/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.adobeio.service.impl;

import acscommons.com.google.common.collect.Lists;
import acscommons.io.jsonwebtoken.Jwts;
import acscommons.io.jsonwebtoken.SignatureAlgorithm;
import acscommons.io.jsonwebtoken.gson.io.GsonSerializer;
import acscommons.io.jsonwebtoken.security.InvalidKeyException;
import com.adobe.acs.commons.adobeio.service.IntegrationService;
import com.adobe.acs.commons.adobeio.service.impl.AdobeioHelper;
import com.adobe.acs.commons.adobeio.service.impl.IntegrationConfiguration;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={IntegrationService.class, Runnable.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"scheduler.expression=0 0 0/1 1/1 * ? *"})
@Designate(ocd=IntegrationConfiguration.class)
public class IntegrationServiceImpl
implements IntegrationService,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegrationServiceImpl.class);
    private static final Base64.Decoder DECODER = Base64.getMimeDecoder();
    @Reference
    private AdobeioHelper helper;
    private String accessToken = null;
    protected IntegrationConfiguration jwtServiceConfig;

    @Activate
    @Modified
    protected void activate(IntegrationConfiguration config) {
        this.jwtServiceConfig = config;
    }

    @Override
    public void run() {
        this.accessToken = this.fetchAccessToken();
        LOGGER.info("access token in run()-method {}", (Object)this.accessToken);
    }

    @Override
    public String getAccessToken() {
        if (StringUtils.isEmpty((CharSequence)this.accessToken)) {
            this.accessToken = this.fetchAccessToken();
        }
        return this.accessToken;
    }

    @Override
    public String getApiKey() {
        return this.jwtServiceConfig.clientId();
    }

    @Override
    public int getTimeoutinMilliSeconds() {
        return this.jwtServiceConfig.timeoutInMilliSeocnds();
    }

    private String fetchAccessToken() {
        String token = "";
        try (CloseableHttpClient client = this.helper.getHttpClient(this.getTimeoutinMilliSeconds());){
            HttpPost post = new HttpPost(this.jwtServiceConfig.endpoint());
            post.addHeader("cache-control", "no-cache");
            post.addHeader("content-type", "application/x-www-form-urlencoded");
            ArrayList<BasicNameValuePair> params = Lists.newArrayList();
            params.add(new BasicNameValuePair("client_id", this.jwtServiceConfig.clientId()));
            params.add(new BasicNameValuePair("client_secret", this.jwtServiceConfig.clientSecret()));
            params.add(new BasicNameValuePair("jwt_token", this.getJwtToken()));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != 200) {
                LOGGER.info("response code {} ", (Object)response.getStatusLine().getStatusCode());
            }
            String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
            LOGGER.info("JSON Response : {}", (Object)result);
            JsonParser parser = new JsonParser();
            JsonObject json = parser.parse(result).getAsJsonObject();
            if (json.has("access_token")) {
                token = json.get("access_token").getAsString();
            } else {
                LOGGER.error("JSON does not contain an access_token");
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to fetch the access token", (Throwable)e);
        }
        LOGGER.info("JWT Access Token : {}", (Object)token);
        return token;
    }

    protected String getJwtToken() throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        String jwtToken = Jwts.builder().setClaims(this.getJwtClaims()).signWith(this.getPrivateKey(), SignatureAlgorithm.RS256).serializeToJsonWith(new GsonSerializer()).compact();
        LOGGER.info("JWT Token : \n {}", (Object)jwtToken);
        return jwtToken;
    }

    private PrivateKey getPrivateKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(IntegrationServiceImpl.buildPkcs8Key(this.jwtServiceConfig.privateKey()));
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(keySpec);
    }

    protected static byte[] buildPkcs8Key(String privateKey) {
        if (privateKey.contains("--BEGIN PRIVATE KEY--")) {
            return DECODER.decode(privateKey.replaceAll("-----\\w+ PRIVATE KEY-----", ""));
        }
        if (!privateKey.contains("--BEGIN RSA PRIVATE KEY--")) {
            LOGGER.error("Invalid cert format: {}", (Object)privateKey);
            return "".getBytes();
        }
        byte[] innerKey = DECODER.decode(privateKey.replaceAll("-----\\w+ RSA PRIVATE KEY-----", ""));
        byte[] result = new byte[innerKey.length + 26];
        System.arraycopy(DECODER.decode("MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKY="), 0, result, 0, 26);
        System.arraycopy(BigInteger.valueOf(result.length - 4).toByteArray(), 0, result, 2, 2);
        System.arraycopy(BigInteger.valueOf(innerKey.length).toByteArray(), 0, result, 24, 2);
        System.arraycopy(innerKey, 0, result, 26, innerKey.length);
        return result;
    }

    private Map getJwtClaims() {
        HashMap<String, Object> jwtClaims = new HashMap<String, Object>();
        jwtClaims.put("iss", this.jwtServiceConfig.amcOrgId());
        jwtClaims.put("sub", this.jwtServiceConfig.techAccountId());
        jwtClaims.put("exp", this.getExpirationDate());
        jwtClaims.put("aud", String.format("%s%s", this.jwtServiceConfig.loginEndpoint(), this.jwtServiceConfig.clientId()));
        String[] claims = this.jwtServiceConfig.adobeLoginClaimKey();
        if (claims != null && claims.length > 0) {
            for (int i = 0; i < claims.length; ++i) {
                jwtClaims.put(claims[i], Boolean.TRUE);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            Gson gson = new Gson();
            LOGGER.debug(gson.toJson(jwtClaims));
        }
        return jwtClaims;
    }

    private long getExpirationDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(13, this.jwtServiceConfig.expirationTimeInSeconds());
        return cal.getTime().getTime();
    }
}

