/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.dam.impl;

import com.adobe.acs.commons.util.ParameterUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.jetbrains.annotations.NotNull;

@SlingServlet(paths={"/bin/acs-commons/dam/custom-components.json"}, generateComponent=false)
@Component(metatype=true, policy=ConfigurationPolicy.REQUIRE, label="ACS AEM Commons - Custom DAM Component List Servlet", description="Servlet to list custom component paths to automatically replace in metadata editor.")
public class CustomComponentActivatorListServlet
extends SlingSafeMethodsServlet {
    private static final String HISTORY = "xmpMM:History=/apps/acs-commons/dam/content/admin/history";
    private static final String FONTS = "xmpTPg:Fonts=/apps/acs-commons/dam/content/admin/fonts";
    private static final String COLORANTS = "xmpTPg:Colorants=/apps/acs-commons/dam/content/admin/color-swatches";
    private static final String LOCATION = "location=/apps/acs-commons/dam/content/admin/asset-location-map";
    private static final String[] DEFAULT_COMPONENTS = new String[]{"xmpMM:History=/apps/acs-commons/dam/content/admin/history", "xmpTPg:Fonts=/apps/acs-commons/dam/content/admin/fonts", "xmpTPg:Colorants=/apps/acs-commons/dam/content/admin/color-swatches", "location=/apps/acs-commons/dam/content/admin/asset-location-map"};
    @Property(label="Components", description="Map in the form <propertyName>=<replacement path>", value={"xmpMM:History=/apps/acs-commons/dam/content/admin/history", "xmpTPg:Fonts=/apps/acs-commons/dam/content/admin/fonts", "xmpTPg:Colorants=/apps/acs-commons/dam/content/admin/color-swatches", "location=/apps/acs-commons/dam/content/admin/asset-location-map"})
    public static final String PROP_COMPONENTS = "components";
    private transient JsonObject json;

    @Activate
    protected void activate(Map<String, Object> config) {
        Map<String, String> components = ParameterUtil.toMap(PropertiesUtil.toStringArray((Object)config.get(PROP_COMPONENTS), (String[])DEFAULT_COMPONENTS), "=");
        JsonArray array = new JsonArray();
        for (Map.Entry<String, String> entry : components.entrySet()) {
            JsonObject obj = new JsonObject();
            obj.addProperty("propertyName", entry.getKey());
            obj.addProperty("componentPath", entry.getValue());
            array.add((JsonElement)obj);
        }
        this.json = new JsonObject();
        this.json.add(PROP_COMPONENTS, (JsonElement)array);
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().print(this.json.toString());
    }
}

