/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.store.jcr.impl.handler;

import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.util.DynamicObjectInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;

public class EntryNodeToCacheKeyHandler {
    private final Node entryNode;
    private final DynamicClassLoaderManager dynamicClassLoaderManager;

    public EntryNodeToCacheKeyHandler(Node entryNode, DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.entryNode = entryNode;
        this.dynamicClassLoaderManager = dynamicClassLoaderManager;
    }

    public CacheKey get() throws RepositoryException, IOException, ClassNotFoundException {
        if (this.entryNode != null) {
            Property cacheKeyProperty = this.entryNode.getProperty("cacheKeySerialized");
            InputStream inputStream = cacheKeyProperty.getBinary().getStream();
            ClassLoader dynamicClassLoader = this.dynamicClassLoaderManager.getDynamicClassLoader();
            DynamicObjectInputStream dynamicObjectInputStream = new DynamicObjectInputStream(inputStream, dynamicClassLoader);
            return (CacheKey)dynamicObjectInputStream.readObject();
        }
        return null;
    }
}

