/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.store.jcr.impl.visitor;

import com.adobe.acs.commons.httpcache.engine.CacheContent;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.httpcache.store.jcr.impl.handler.EntryNodeToCacheContentHandler;
import com.adobe.acs.commons.httpcache.store.jcr.impl.handler.EntryNodeToCacheKeyHandler;
import com.adobe.acs.commons.httpcache.store.jcr.impl.visitor.AbstractNodeVisitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryNodeMapVisitor
extends AbstractNodeVisitor {
    final Map<CacheKey, CacheContent> cache = new HashMap<CacheKey, CacheContent>();
    private final DynamicClassLoaderManager dclm;
    private static final Logger log = LoggerFactory.getLogger(EntryNodeMapVisitor.class);

    public EntryNodeMapVisitor(int maxLevel, DynamicClassLoaderManager dclm) {
        super(maxLevel, -1L);
        this.dclm = dclm;
    }

    public Map<CacheKey, CacheContent> getCache() {
        return this.cache;
    }

    @Override
    protected void entering(Node node, int level) throws RepositoryException {
        super.entering(node, level);
        if (EntryNodeMapVisitor.isCacheEntryNode(node)) {
            try {
                CacheKey cacheKey = this.getCacheKey(node);
                CacheContent content = this.getCacheContent(node);
                this.cache.put(cacheKey, content);
            }
            catch (Exception e) {
                log.error("Error in reading cache node!", (Throwable)e);
            }
        }
    }

    protected CacheContent getCacheContent(Node node) throws RepositoryException {
        return new EntryNodeToCacheContentHandler(node).get();
    }

    protected CacheKey getCacheKey(Node node) throws RepositoryException, IOException, ClassNotFoundException {
        return new EntryNodeToCacheKeyHandler(node, this.dclm).get();
    }
}

