/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.marketo.impl;

import acscommons.com.google.common.cache.CacheBuilder;
import acscommons.com.google.common.cache.CacheLoader;
import acscommons.com.google.common.cache.LoadingCache;
import com.adobe.acs.commons.marketo.MarketoClientConfiguration;
import com.adobe.acs.commons.marketo.MarketoClientConfigurationManager;
import com.adobe.acs.commons.marketo.client.MarketoClient;
import com.adobe.acs.commons.marketo.client.MarketoForm;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=GET", "sling.servlet.resourceTypes=acs-commons/components/content/marketo-form/form-data-source"})
public class MarketoFormDataSource
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(MarketoFormDataSource.class);
    private static final long serialVersionUID = -4047967365420628578L;
    private transient MarketoClient client;
    private transient LoadingCache<MarketoClientConfiguration, List<MarketoForm>> formCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build(new CacheLoader<MarketoClientConfiguration, List<MarketoForm>>(){

        @Override
        public List<MarketoForm> load(MarketoClientConfiguration config) throws Exception {
            return MarketoFormDataSource.this.client.getForms(config);
        }
    });

    @Reference
    public void bindMarketoClient(MarketoClient client) {
        this.client = client;
    }

    public void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) {
        log.trace("doGet");
        List<Object> options = null;
        MarketoClientConfiguration config = null;
        try {
            MarketoClientConfigurationManager cfgMgr = (MarketoClientConfigurationManager)request.adaptTo(MarketoClientConfigurationManager.class);
            if (cfgMgr != null) {
                config = cfgMgr.getConfiguration();
            }
            if (config == null) {
                String msg = String.format("No Marketo configuration found for resource '%s'", request.getRequestPathInfo().getSuffix());
                throw new RepositoryException(msg);
            }
            int currentValue = this.getCurrentValue(request);
            options = this.formCache.get(config).stream().sorted((f1, f2) -> f1.getName().compareTo(f2.getName())).map(f -> {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("selected", currentValue == f.getId());
                data.put("value", f.getId());
                data.put("text", String.format("%s [%s] (%s)", f.getName(), f.getLocale(), f.getId()));
                return new ValueMapResource(request.getResourceResolver(), new ResourceMetadata(), "nt:unstructured", (ValueMap)new ValueMapDecorator(data));
            }).collect(Collectors.toList());
            log.debug("Loaded {} options", (Object)options.size());
        }
        catch (Exception e) {
            log.warn("Failed to load Marketo forms", (Throwable)e);
            options = new ArrayList<ValueMapResource>();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("value", "");
            data.put("text", "Unable to load forms from Marketo");
            options.add(new ValueMapResource(request.getResourceResolver(), new ResourceMetadata(), "nt:unstructured", (ValueMap)new ValueMapDecorator(data)));
        }
        request.setAttribute(DataSource.class.getName(), (Object)new SimpleDataSource(options.iterator()));
    }

    private int getCurrentValue(SlingHttpServletRequest request) {
        Resource suffix = request.getRequestPathInfo().getSuffixResource();
        if (suffix != null) {
            return (Integer)suffix.getValueMap().get("formId", (Object)-1);
        }
        return -1;
    }
}

