/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.models.injectors.impl;

import com.adobe.acs.commons.models.injectors.annotation.HierarchicalPageProperty;
import com.adobe.acs.commons.models.injectors.annotation.PageProperty;
import com.adobe.acs.commons.models.injectors.impl.InjectorUtils;
import com.adobe.acs.commons.util.impl.ReflectionUtil;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.wcm.api.Page;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.ranking:Integer=5502"}, service={Injector.class})
public class HierarchicalPagePropertyInjector
implements Injector {
    public static final String SOURCE = "hierarchical-page-property";
    private static final Logger LOG = LoggerFactory.getLogger(HierarchicalPagePropertyInjector.class);

    public String getName() {
        return SOURCE;
    }

    public Object getValue(Object adaptable, String name, Type declaredType, AnnotatedElement element, DisposalCallbackRegistry callbackRegistry) {
        Resource adaptableRes;
        if (!element.isAnnotationPresent(HierarchicalPageProperty.class) && !element.isAnnotationPresent(PageProperty.class)) {
            return null;
        }
        Resource currentResource = InjectorUtils.getResource(adaptable);
        if (currentResource != null && (adaptableRes = this.lookUpFromPage(adaptable, currentResource, element)) != null) {
            if (this.useInheritance(element)) {
                HierarchyNodeInheritanceValueMap inheritanceValueMap = new HierarchyNodeInheritanceValueMap(adaptableRes);
                return ReflectionUtil.convertValueMapValue((InheritanceValueMap)inheritanceValueMap, name, declaredType);
            }
            return ReflectionUtil.convertValueMapValue(adaptableRes.getValueMap(), name, declaredType);
        }
        return null;
    }

    private Resource lookUpFromPage(Object adaptable, Resource currentResource, AnnotatedElement element) {
        HierarchicalPageProperty annotation;
        Page containingPage;
        boolean useCurrentPage = this.useCurrentPage(element);
        if (useCurrentPage) {
            containingPage = InjectorUtils.getCurrentPage(adaptable);
            if (containingPage == null) {
                LOG.error("Could not find current page for resource: {}. Only SlingHttpServletRequest is supported as adaptable", (Object)InjectorUtils.getResource(adaptable).getPath());
            }
        } else {
            containingPage = InjectorUtils.getResourcePage(currentResource);
        }
        if (containingPage != null && element.isAnnotationPresent(HierarchicalPageProperty.class) && (annotation = element.getAnnotation(HierarchicalPageProperty.class)).traverseFromAbsoluteParent() > -1) {
            containingPage = containingPage.getAbsoluteParent(annotation.traverseFromAbsoluteParent());
        }
        return containingPage != null ? containingPage.getContentResource() : null;
    }

    private boolean useCurrentPage(AnnotatedElement element) {
        if (element.isAnnotationPresent(HierarchicalPageProperty.class)) {
            return element.getAnnotation(HierarchicalPageProperty.class).useCurrentPage();
        }
        if (element.isAnnotationPresent(PageProperty.class)) {
            return element.getAnnotation(PageProperty.class).useCurrentPage();
        }
        return false;
    }

    private boolean useInheritance(AnnotatedElement element) {
        return element.isAnnotationPresent(HierarchicalPageProperty.class) && element.getAnnotation(HierarchicalPageProperty.class).inherit();
    }
}

