/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.models.via.impl;

import com.adobe.acs.commons.models.injectors.impl.InjectorUtils;
import com.adobe.acs.commons.models.via.annotations.PageContentResourceViaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.ViaProviderType;
import org.apache.sling.models.spi.ViaProvider;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ViaProvider.class})
public class PageContentResourceViaProvider
implements ViaProvider {
    public static final String VIA_CURRENT_PAGE = "currentPage";
    private static final Logger logger = LoggerFactory.getLogger(PageContentResourceViaProvider.class);

    public Class<? extends ViaProviderType> getType() {
        return PageContentResourceViaType.class;
    }

    public Object getAdaptable(Object original, String value) {
        try {
            Resource resource;
            if (StringUtils.equals((CharSequence)value, (CharSequence)VIA_CURRENT_PAGE)) {
                resource = InjectorUtils.getCurrentPage(original).getContentResource();
                if (resource == null) {
                    logger.error("Could not find current page for resource: {}. Only SlingHttpServletRequest is supported as adaptable", (Object)InjectorUtils.getResource(original).getPath());
                }
            } else {
                resource = InjectorUtils.getResourcePage(original).getContentResource();
            }
            return resource;
        }
        catch (NullPointerException ex) {
            logger.error("Error while getting content policy properties", (Throwable)ex);
            return null;
        }
    }
}

