/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.filter;

import acscommons.com.google.common.cache.Cache;
import acscommons.com.google.common.cache.CacheBuilder;
import com.adobe.acs.commons.redirects.LocationHeaderAdjuster;
import com.adobe.acs.commons.redirects.filter.RedirectFilterMBean;
import com.adobe.acs.commons.redirects.models.RedirectConfiguration;
import com.adobe.acs.commons.redirects.models.RedirectMatch;
import com.adobe.acs.commons.redirects.models.RedirectRule;
import com.adobe.acs.commons.redirects.models.RedirectState;
import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import com.day.cq.replication.ReplicationEvent;
import com.day.cq.wcm.api.WCMMode;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class, RedirectFilterMBean.class, EventHandler.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.description=A request filter implementing support for virtual redirects", "sling.filter.scope=REQUEST", "service.ranking:Integer=1900", "jmx.objectname=com.adobe.acs.commons:type=Redirect Manager", "event.topics=com/day/cq/replication", "event.topics=com/adobe/granite/replication"})
@Designate(ocd=Configuration.class)
public class RedirectFilter
extends AnnotatedStandardMBean
implements Filter,
EventHandler,
ResourceChangeListener,
RedirectFilterMBean {
    public static final String ACS_REDIRECTS_RESOURCE_TYPE = "acs-commons/components/utilities/manage-redirects";
    public static final String REDIRECT_RULE_RESOURCE_TYPE = "acs-commons/components/utilities/manage-redirects/redirect-row";
    public static final String DEFAULT_CONFIG_BUCKET = "settings";
    public static final String DEFAULT_CONFIG_NAME = "redirects";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Reference
    ConfigurationResourceResolver configResolver;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    LocationHeaderAdjuster urlAdjuster;
    private ServiceRegistration<?> listenerRegistration;
    private boolean enabled;
    private boolean mapUrls;
    private boolean preserveQueryString;
    private List<Header> onDeliveryHeaders = Collections.emptyList();
    private Collection<String> methods = Arrays.asList("GET", "HEAD");
    private Collection<String> exts = Collections.emptySet();
    private Collection<String> paths = Collections.emptySet();
    private Configuration config;
    private ExecutorService executor;
    Cache<String, RedirectConfiguration> rulesCache;

    public RedirectFilter() throws NotCompliantMBeanException {
        super(RedirectFilterMBean.class);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Activate
    @Modified
    protected final void activate(Configuration config, BundleContext context) {
        this.config = config;
        this.enabled = config.enabled();
        if (this.enabled) {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("resource.paths", "/conf");
            this.listenerRegistration = context.registerService(ResourceChangeListener.class, (Object)this, properties);
            log.debug("Registered {}:{}", (Object)"service.id", this.listenerRegistration.getReference().getProperty("service.id"));
            this.exts = config.extensions() == null ? Collections.emptySet() : (Collection)Arrays.stream(config.extensions()).filter(ext -> !ext.isEmpty()).collect(Collectors.toSet());
            this.paths = config.paths() == null ? Collections.emptySet() : (Collection)Arrays.stream(config.paths()).filter(path -> !path.isEmpty()).collect(Collectors.toSet());
            this.mapUrls = config.mapUrls();
            this.onDeliveryHeaders = new ArrayList<Header>();
            for (String kv : config.additionalHeaders()) {
                int idx = kv.indexOf(58);
                if (idx == -1 || idx > kv.length() - 1) {
                    log.error("invalid on-delivery header: {}", (Object)kv);
                    continue;
                }
                String name = kv.substring(0, idx).trim();
                String value = kv.substring(idx + 1).trim();
                this.onDeliveryHeaders.add((Header)new BasicHeader(name, value));
            }
            this.preserveQueryString = config.preserveQueryString();
            log.debug("exts: {}, paths: {}, rewriteUrls: {}", new Object[]{this.exts, this.paths, this.mapUrls});
            this.executor = Executors.newSingleThreadExecutor();
            this.rulesCache = CacheBuilder.newBuilder().build();
        }
    }

    @Modified
    protected void modify(BundleContext context, Configuration config) {
        this.deactivate();
        this.activate(config, context);
    }

    @Deactivate
    public void deactivate() {
        if (this.enabled) {
            this.executor.shutdown();
        }
        if (this.listenerRegistration != null) {
            log.debug("unregistering ... ");
            this.listenerRegistration.unregister();
            this.listenerRegistration = null;
        }
    }

    Configuration getConfiguration() {
        return this.config;
    }

    public void handleEvent(Event event) {
        ReplicationEvent replicationEvent = ReplicationEvent.fromEvent((Event)event);
        if (this.enabled && replicationEvent != null) {
            String redirectSubPath = this.config.bucketName() + "/" + this.config.configName();
            String[] replicationPaths = replicationEvent.getReplicationAction().getPaths();
            if (replicationPaths != null) {
                for (String path : replicationPaths) {
                    if (!path.contains(redirectSubPath)) continue;
                    this.executor.submit(() -> this.invalidate(path));
                }
            }
        }
    }

    public void onChange(List<ResourceChange> changes) {
        if (!this.enabled) {
            return;
        }
        String redirectSubPath = this.config.bucketName() + "/" + this.config.configName();
        for (ResourceChange e : changes) {
            String path = e.getPath();
            if (!path.contains(redirectSubPath)) continue;
            this.executor.submit(() -> this.invalidate(path));
        }
    }

    void invalidate(String changePath) {
        String redirectSubPath = this.config.bucketName() + "/" + this.config.configName();
        String cacheKey = changePath;
        while (cacheKey != null) {
            if (cacheKey.endsWith(redirectSubPath)) {
                log.debug("invalidating {}", (Object)cacheKey);
                this.rulesCache.invalidate(cacheKey);
                break;
            }
            cacheKey = ResourceUtil.getParent((String)cacheKey);
        }
    }

    @Override
    public void invalidateAll() {
        this.rulesCache.invalidateAll();
    }

    RedirectConfiguration loadRules(Resource storageResource) {
        long t0 = System.currentTimeMillis();
        String storageSuffix = this.getBucket() + "/" + this.getConfigName();
        RedirectConfiguration rules = new RedirectConfiguration(storageResource, storageSuffix);
        log.debug("{} rules loaded from {} in {} ms", new Object[]{rules.getPathRules().size() + rules.getPatternRules().size(), storageResource.getPath(), System.currentTimeMillis() - t0});
        return rules;
    }

    public static Collection<RedirectRule> getRules(Resource resource) {
        ArrayList<RedirectRule> rules = new ArrayList<RedirectRule>();
        for (Resource res : resource.getChildren()) {
            RedirectRule rule;
            if (!res.isResourceType(REDIRECT_RULE_RESOURCE_TYPE) || (rule = (RedirectRule)res.adaptTo(RedirectRule.class)) == null) continue;
            rules.add(rule);
        }
        return rules;
    }

    Cache<String, RedirectConfiguration> getRulesCache() {
        return this.rulesCache;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof SlingHttpServletRequest) || !(response instanceof SlingHttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        SlingHttpServletResponse slingResponse = (SlingHttpServletResponse)response;
        if (this.isEnabled() && this.doesRequestMatch(slingRequest) && this.handleRedirect(slingRequest, slingResponse)) {
            return;
        }
        chain.doFilter(request, response);
    }

    boolean handleRedirect(SlingHttpServletRequest slingRequest, SlingHttpServletResponse slingResponse) {
        long t0 = System.currentTimeMillis();
        boolean redirected = false;
        RedirectMatch match = this.match(slingRequest);
        if (match != null) {
            RedirectRule redirectRule = match.getRule();
            if (redirectRule.getState() != RedirectState.ACTIVE) {
                log.debug("redirect rule matched, but didn't meet on/off time criteria: untilDate: {}, effectiveFrom: {}", (Object)redirectRule.getUntilDate(), (Object)redirectRule.getEffectiveFrom());
            } else {
                RequestPathInfo pathInfo = slingRequest.getRequestPathInfo();
                String resourcePath = pathInfo.getResourcePath();
                String location = this.evaluate(match, slingRequest);
                log.trace("matched {} to {} in {} ms", new Object[]{resourcePath, redirectRule.toString(), System.currentTimeMillis() - t0});
                log.debug("Redirecting {} to {}, statusCode: {}", new Object[]{resourcePath, location, redirectRule.getStatusCode()});
                slingResponse.setHeader("Location", location);
                this.setAdditionalHeaders(redirectRule, (HttpServletResponse)slingResponse);
                slingResponse.setStatus(redirectRule.getStatusCode());
                redirected = true;
            }
        }
        return redirected;
    }

    String evaluate(RedirectMatch match, SlingHttpServletRequest slingRequest) {
        String queryString;
        Resource configResource = this.configResolver.getResource(slingRequest.getResource(), this.config.bucketName(), this.config.configName());
        ValueMap properties = configResource.getValueMap();
        String contextPrefix = (String)properties.get("contextPrefix", (Object)"");
        RequestPathInfo pathInfo = slingRequest.getRequestPathInfo();
        String location = this.createFullPath(match.getRule().evaluate(match.getMatcher()), match.getRule(), contextPrefix);
        if (StringUtils.startsWith((CharSequence)location, (CharSequence)"/") && !StringUtils.startsWith((CharSequence)location, (CharSequence)"//")) {
            String ext = pathInfo.getExtension();
            if (ext != null && this.config.preserveExtension() && !location.endsWith(ext)) {
                location = location + "." + ext;
            }
            if (this.mapUrls()) {
                location = this.mapUrl(location, slingRequest);
            }
            if (this.urlAdjuster != null) {
                location = this.urlAdjuster.adjust(slingRequest, location);
            }
        }
        if (this.preserveQueryString && (queryString = slingRequest.getQueryString()) != null) {
            location = this.preserveQueryString(location, queryString);
        }
        return location;
    }

    String preserveQueryString(String location, String queryString) {
        int idx = location.indexOf(63);
        if (idx == -1) {
            idx = location.indexOf(35);
        }
        if (idx != -1) {
            location = location.substring(0, idx);
        }
        location = location + "?" + queryString;
        return location;
    }

    String mapUrl(String url, SlingHttpServletRequest slingRequest) {
        return slingRequest.getResourceResolver().map((HttpServletRequest)slingRequest, url);
    }

    public void destroy() {
    }

    protected boolean mapUrls() {
        return this.mapUrls;
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    protected Collection<String> getExtensions() {
        return Collections.unmodifiableCollection(this.exts);
    }

    protected Collection<String> getPaths() {
        return Collections.unmodifiableCollection(this.paths);
    }

    protected Collection<String> getMethods() {
        return Collections.unmodifiableCollection(this.methods);
    }

    protected List<Header> getOnDeliveryHeaders() {
        return Collections.unmodifiableList(this.onDeliveryHeaders);
    }

    private boolean doesRequestMatch(SlingHttpServletRequest request) {
        boolean matches;
        WCMMode wcmMode = WCMMode.fromRequest((ServletRequest)request);
        if (wcmMode != null && wcmMode != WCMMode.DISABLED) {
            log.trace("Request in author mode: {}, no redirection.", (Object)wcmMode);
            return false;
        }
        String method = request.getMethod();
        if (!this.getMethods().contains(method)) {
            log.trace("Request method [{}] does not match any of {}.", (Object)method, this.methods);
            return false;
        }
        String ext = request.getRequestPathInfo().getExtension();
        if (ext != null && !this.getExtensions().isEmpty() && !this.getExtensions().contains(ext)) {
            log.trace("Request extension [{}] does not match any of {}.", (Object)ext, this.exts);
            return false;
        }
        String resourcePath = request.getRequestPathInfo().getResourcePath();
        boolean bl = matches = this.getPaths().isEmpty() || this.getPaths().stream().anyMatch(p -> p.equals("/") || resourcePath.startsWith(p + "/"));
        if (!matches) {
            log.trace("Request path [{}] not within any of {}.", (Object)resourcePath, this.paths);
            return false;
        }
        return true;
    }

    RedirectMatch match(SlingHttpServletRequest slingRequest) {
        Resource resource = slingRequest.getResource();
        Resource configResource = this.configResolver.getResource(resource, this.config.bucketName(), this.config.configName());
        if (configResource == null) {
            log.warn("no caconfig found for {}, bucketName: {}, configName: {}, user: {}", new Object[]{resource.getPath(), this.config.bucketName(), this.config.configName(), slingRequest.getResourceResolver().getUserID()});
            return null;
        }
        String configPath = configResource.getPath();
        try {
            String mappedUrl;
            RedirectMatch m;
            RedirectConfiguration rules = this.rulesCache.get(configPath, () -> this.loadRules(configResource));
            RequestPathInfo requestPathInfo = slingRequest.getRequestPathInfo();
            String resourcePath = requestPathInfo.getResourcePath();
            ValueMap properties = configResource.getValueMap();
            String contextPrefix = (String)properties.get("contextPrefix", (Object)"");
            boolean ignoreSelectors = (Boolean)properties.get("ignoreSelectors", (Object)false);
            if (ignoreSelectors && requestPathInfo.getSelectorString() != null) {
                resourcePath = RedirectFilter.removeSelectors(resourcePath, resource.getResourceMetadata().getResolutionPathInfo());
            }
            if ((m = rules.match(resourcePath, contextPrefix, slingRequest)) == null && this.mapUrls() && !resourcePath.equals(mappedUrl = this.mapUrl(resourcePath, slingRequest))) {
                String mappedPath = URI.create(mappedUrl).getPath();
                m = rules.match(mappedPath, "", slingRequest);
            }
            return m;
        }
        catch (ExecutionException e) {
            log.error("failed to load redirect rules from {}", (Object)configPath, (Object)e);
            return null;
        }
    }

    private String createFullPath(String path, RedirectRule redirectRule, String contextPrefix) {
        if (path == null) {
            return "";
        }
        if (redirectRule.getContextPrefixIgnored() || this.isAbsoluteUrl(path) || path.startsWith(contextPrefix)) {
            return path;
        }
        return contextPrefix + path;
    }

    private boolean isAbsoluteUrl(String path) {
        Pattern httpRegex = Pattern.compile("^(https?:\\/\\/|www\\.|\\/\\/)(.*)");
        Matcher httpMatcher = httpRegex.matcher(path);
        return httpMatcher.matches();
    }

    static String removeSelectors(String resolutionPath, String resolutionPathInfo) {
        if (resolutionPathInfo != null) {
            return resolutionPath.replace(resolutionPathInfo, "");
        }
        return resolutionPath;
    }

    @Override
    public TabularData getRedirectRules(String storagePath) throws OpenDataException {
        String sourceUrl = "Source Url";
        String targetUrl = "Target Url";
        String statusCode = "Status Code";
        String redirectRules = "Redirect Rules";
        CompositeType cacheEntryType = new CompositeType(redirectRules, redirectRules, new String[]{sourceUrl, targetUrl, statusCode}, new String[]{sourceUrl, targetUrl, statusCode}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER});
        TabularDataSupport tabularData = new TabularDataSupport(new TabularType(redirectRules, redirectRules, cacheEntryType, new String[]{sourceUrl}));
        RedirectConfiguration cfg = this.rulesCache.getIfPresent(storagePath);
        if (cfg != null) {
            Map<Pattern, RedirectRule> patternMatchingRules;
            Map<String, RedirectRule> ignoreCaseRules;
            ArrayList<RedirectRule> rules = new ArrayList<RedirectRule>();
            Map<String, RedirectRule> pathMatchingRules = cfg.getPathRules();
            if (pathMatchingRules != null) {
                rules.addAll(pathMatchingRules.values());
            }
            if ((ignoreCaseRules = cfg.getCaseInsensitivePathRules()) != null) {
                rules.addAll(ignoreCaseRules.values());
            }
            if ((patternMatchingRules = cfg.getPatternRules()) != null) {
                rules.addAll(patternMatchingRules.values());
            }
            for (RedirectRule rule : rules) {
                LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
                row.put(sourceUrl, rule.getSource());
                row.put(targetUrl, rule.getTarget());
                row.put(statusCode, rule.getStatusCode());
                tabularData.put(new CompositeDataSupport(cacheEntryType, row));
            }
        }
        return tabularData;
    }

    @Override
    public Collection<String> getRedirectConfigurations() {
        return this.rulesCache.asMap().keySet();
    }

    @Override
    public String getBucket() {
        return this.config.bucketName();
    }

    @Override
    public String getConfigName() {
        return this.config.configName();
    }

    void setAdditionalHeaders(RedirectRule redirectRule, HttpServletResponse response) {
        for (Header header : this.onDeliveryHeaders) {
            response.addHeader(header.getName(), header.getValue());
        }
        String ccHeader = redirectRule.getCacheControlHeader();
        if (StringUtils.isEmpty((CharSequence)ccHeader)) {
            ccHeader = redirectRule.getDefaultCacheControlHeader();
        }
        if (!StringUtils.isEmpty((CharSequence)ccHeader)) {
            response.addHeader("Cache-Control", ccHeader);
        }
    }

    @ObjectClassDefinition(name="ACS Commons Redirect Filter")
    public static @interface Configuration {
        @AttributeDefinition(name="Enable Redirect Filter", description="Indicates whether the redirect filter is enabled or not.", type=AttributeType.BOOLEAN)
        public boolean enabled() default false;

        @AttributeDefinition(name="Rewrite Location Header", description="Apply Sling Resource Mappings (/etc/map) to Location header. Use if Location header should be rewritten using ResourceResolver#map", type=AttributeType.BOOLEAN)
        public boolean mapUrls() default true;

        @AttributeDefinition(name="Request Extensions", description="List of extensions for which redirection is allowed", type=AttributeType.STRING)
        public String[] extensions() default {};

        @AttributeDefinition(name="Request Paths", description="List of paths for which redirection is allowed", type=AttributeType.STRING)
        public String[] paths() default {"/content"};

        @AttributeDefinition(name="Preserve Query String", description="Preserve query string in redirects", type=AttributeType.BOOLEAN)
        public boolean preserveQueryString() default true;

        @AttributeDefinition(name="Preserve Extension", description="Whether to preserve extensions. When this flag is checked (default), redirect filter will preserve the extension from the request, e.g. append .html to the Location header. ", type=AttributeType.BOOLEAN)
        public boolean preserveExtension() default true;

        @AttributeDefinition(name="Additional Response Headers", description="Optional response headers in the name:value format to apply on delivery, e.g. Cache-Control: max-age=3600", type=AttributeType.STRING)
        public String[] additionalHeaders() default {};

        @AttributeDefinition(name="Configuration bucket name", description="name of the parent folder where to store redirect rules. Default is settings. ", type=AttributeType.STRING)
        public String bucketName() default "settings";

        @AttributeDefinition(name="Configuration Name", description="The node name to store redirect configurations. Default is 'redirects'  which means the default path to store redirects is /conf/global/settings/redirects  where 'settings' is the bucket and 'redirects' is the config name", type=AttributeType.STRING)
        public String configName() default "redirects";
    }
}

