/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.rewriter.impl;

import com.adobe.acs.commons.rewriter.ContentHandlerBasedTransformer;
import com.adobe.acs.commons.util.ParameterUtil;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Transformer;
import org.apache.sling.rewriter.TransformerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@Component(label="ACS AEM Commons - Resource Resolver Map Rewriter", description="Rewriter pipeline component which resourceResolver.map's any element/attribute.", metatype=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(label="Rewriter Pipeline Type", description="Type identifier to be referenced in rewriter pipeline configuration.", name="pipeline.type", value={"resourceresolver-map"}, propertyPrivate=true), @Property(name="webconsole.configurationFactory.nameHint", value={"Pipeline Type: {pipeline.type}, for element:attributes [{attributes}]"})})
@Service
public final class ResourceResolverMapTransformerFactory
implements TransformerFactory {
    private static final Logger log = LoggerFactory.getLogger(ResourceResolverMapTransformerFactory.class);
    private static final String[] DEFAULT_ATTRIBUTES = new String[]{"img:src"};
    private Map<String, String[]> attributes;
    @Property(label="Rewrite Attributes", description="List of element/attribute pairs to rewrite", cardinality=0x7FFFFFFF, value={"img:src"})
    private static final String PROP_ATTRIBUTES = "attributes";

    public Transformer createTransformer() {
        return new ResourceResolverMapTransformer();
    }

    protected Attributes rebuildAttributes(SlingHttpServletRequest slingRequest, String elementName, Attributes attrs) {
        if (slingRequest == null || !this.attributes.containsKey(elementName)) {
            return attrs;
        }
        Object[] modifiableAttributes = this.attributes.get(elementName);
        AttributesImpl newAttrs = new AttributesImpl(attrs);
        int len = newAttrs.getLength();
        for (int i = 0; i < len; ++i) {
            String attrValue;
            String attrName = newAttrs.getLocalName(i);
            if (!ArrayUtils.contains((Object[])modifiableAttributes, (Object)attrName) || !StringUtils.startsWith((CharSequence)(attrValue = newAttrs.getValue(i)), (CharSequence)"/") || StringUtils.startsWith((CharSequence)attrValue, (CharSequence)"//")) continue;
            try {
                String attrValueDecoded = new URLCodec().decode(attrValue);
                newAttrs.setValue(i, slingRequest.getResourceResolver().map((HttpServletRequest)slingRequest, attrValueDecoded));
                continue;
            }
            catch (DecoderException e) {
                log.error("Could not decode the attribute value", (Throwable)e);
                newAttrs.setValue(i, slingRequest.getResourceResolver().map((HttpServletRequest)slingRequest, attrValue));
            }
        }
        return newAttrs;
    }

    @Activate
    protected void activate(Map<String, Object> config) {
        String[] test = PropertiesUtil.toStringArray((Object)config.get(PROP_ATTRIBUTES), (String[])new String[0]);
        String[] normalizedValue = PropertiesUtil.toStringArray((Object)config.get(PROP_ATTRIBUTES), (String[])DEFAULT_ATTRIBUTES);
        if (test.length == 1 && StringUtils.contains((CharSequence)test[0], (CharSequence)",")) {
            normalizedValue = StringUtils.split((String)test[0], (String)",");
        }
        this.attributes = ParameterUtil.toMap(normalizedValue, ":", ",");
    }

    public final class ResourceResolverMapTransformer
    extends ContentHandlerBasedTransformer {
        private SlingHttpServletRequest slingRequest;

        @Override
        public void init(ProcessingContext context, ProcessingComponentConfiguration config) throws IOException {
            super.init(context, config);
            this.slingRequest = context.getRequest();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.getContentHandler().startElement(namespaceURI, localName, qName, ResourceResolverMapTransformerFactory.this.rebuildAttributes(this.slingRequest, localName, atts));
        }
    }
}

