/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import acscommons.com.google.common.io.ByteStreams;
import com.day.cq.commons.Externalizer;
import com.day.cq.commons.Filter;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageFilter;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.PageManagerFactory;
import com.day.text.Text;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.selectors=robots", "sling.servlet.extensions=txt", "sling.servlet.methods=GET"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=RobotsServletConfig.class, factory=true)
public final class RobotsServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(RobotsServlet.class);
    private static final String ALLOW = "Allow: ";
    private static final String USER_AGENT = "User-agent: ";
    private static final String SITEMAP = "Sitemap: ";
    private static final String DISALLOW = "Disallow: ";
    private static final String CRAWL_DELAY = "Crawl-delay: ";
    private String externalizerDomain;
    private String robotsContentsPropertyPath;
    private boolean printGroupingComments;
    private int crawlDelay;
    private transient RobotsRuleSet rules;
    @Reference
    private transient Externalizer externalizer;
    @Reference
    private transient PageManagerFactory pageManagerFactory;

    @Activate
    protected void activate(RobotsServletConfig config) {
        this.externalizerDomain = config.externalizer_domain();
        this.robotsContentsPropertyPath = config.robots_content_property_path();
        this.printGroupingComments = config.print_grouping_comments();
        this.crawlDelay = config.crawl_delay();
        this.rules = new RobotsRuleSet(config);
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        this.write(request, response);
    }

    private void write(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)this.robotsContentsPropertyPath)) {
            this.writeFromBinaryProperty(request, response);
        } else {
            this.writeFromOsgiConfig(request, response);
        }
    }

    private void writeFromOsgiConfig(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        PageManager pageManager = this.pageManagerFactory.getPageManager(request.getResourceResolver());
        Page page = pageManager.getContainingPage(request.getResource());
        if (page != null) {
            this.addCrawlDelay(writer);
            this.rules.getGroups().forEach(group -> this.writeGroup((RobotsRuleGroup)group, request.getResourceResolver(), page, writer));
            this.rules.getSitemaps().stream().map(sitemap -> this.buildSitemapDirective((String)sitemap, request, pageManager, request.getResourceResolver())).forEach(writer::println);
            if (!this.rules.getSitemapProperties().isEmpty()) {
                this.addRuleForPageHavingBooleanProperty(page, this.rules.getSitemapProperties(), writer, currentPage -> this.buildSitemapDirective(currentPage.getPath(), request, pageManager, request.getResourceResolver()), false);
            }
        } else {
            response.sendError(400);
        }
    }

    private void writeGroup(RobotsRuleGroup group, ResourceResolver resourceResolver, Page page, PrintWriter writer) {
        List<String> disallowPathProperties;
        List<String> allowPathProperties;
        if (this.printGroupingComments) {
            writer.println("# Start Group: " + group.getGroupName());
        }
        PageManager pageManager = page.getPageManager();
        group.getUserAgents().stream().map(this::buildUserAgentsDirective).forEach(writer::println);
        group.getAllowed().stream().map(allowed -> this.buildAllowedOrDisallowedDirective(true, (String)allowed, pageManager, resourceResolver, false)).forEach(writer::println);
        List<String> allowPageProperties = group.getAllowPageProperties();
        if (!allowPageProperties.isEmpty()) {
            this.addRuleForPageHavingBooleanProperty(page, allowPageProperties, writer, currentPage -> this.buildAllowedOrDisallowedDirective(true, currentPage.getPath(), pageManager, resourceResolver, true), false);
        }
        if (!(allowPathProperties = group.getAllowPathProperties()).isEmpty()) {
            this.addRuleForPageHavingBooleanProperty(page, allowPathProperties, writer, currentPage -> this.buildAllowedOrDisallowedDirective(true, currentPage.getPath(), pageManager, resourceResolver, false), true);
        }
        group.getDisallowed().stream().map(disallowed -> this.buildAllowedOrDisallowedDirective(false, (String)disallowed, page.getPageManager(), resourceResolver, false)).forEach(writer::println);
        List<String> disallowPageProperties = group.getDisallowPageProperties();
        if (!disallowPageProperties.isEmpty()) {
            this.addRuleForPageHavingBooleanProperty(page, disallowPageProperties, writer, currentPage -> this.buildAllowedOrDisallowedDirective(false, currentPage.getPath(), pageManager, resourceResolver, true), false);
        }
        if (!(disallowPathProperties = group.getDisallowPathProperties()).isEmpty()) {
            this.addRuleForPageHavingBooleanProperty(page, disallowPathProperties, writer, currentPage -> this.buildAllowedOrDisallowedDirective(false, currentPage.getPath(), pageManager, resourceResolver, false), true);
        }
        if (this.printGroupingComments) {
            writer.println("# End Group: " + group.getGroupName());
        }
    }

    private void addRuleForPageHavingBooleanProperty(Page page, List<String> propNames, PrintWriter writer, Function<Page, String> ruleBuilderFunc, boolean doNotRecurseIfRuleAdded) {
        ValueMap pageProps = page.getProperties();
        boolean added = false;
        for (String prop : propNames) {
            boolean shouldAdd = (Boolean)pageProps.get(prop, (Object)false);
            if (!shouldAdd) continue;
            String rule = ruleBuilderFunc.apply(page);
            writer.println(rule);
            added = true;
            break;
        }
        if (!added || !doNotRecurseIfRuleAdded) {
            Iterator pageIterator = page.listChildren((Filter)new PageFilter(false, true), false);
            pageIterator.forEachRemaining(child -> this.addRuleForPageHavingBooleanProperty((Page)child, propNames, writer, ruleBuilderFunc, doNotRecurseIfRuleAdded));
        }
    }

    private void writeFromBinaryProperty(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String absoluteRobotsContentsPropertyPath = this.robotsContentsPropertyPath;
        if (!absoluteRobotsContentsPropertyPath.startsWith("/")) {
            absoluteRobotsContentsPropertyPath = request.getResource().getPath() + "/" + this.robotsContentsPropertyPath;
        }
        boolean written = false;
        int separator = absoluteRobotsContentsPropertyPath.lastIndexOf(47);
        if (separator == -1 || separator == absoluteRobotsContentsPropertyPath.length() - 1) {
            log.warn("no '/' separator found in configured property path or it ends with a separator : {}.", (Object)absoluteRobotsContentsPropertyPath);
        } else {
            String resourcePath = absoluteRobotsContentsPropertyPath.substring(0, separator);
            String propertyName = absoluteRobotsContentsPropertyPath.substring(separator + 1);
            Resource resource = request.getResourceResolver().getResource(resourcePath);
            if (resource != null) {
                Object property = resource.getValueMap().get((Object)propertyName);
                if (property != null) {
                    if (property instanceof String) {
                        response.getWriter().print((String)String.class.cast(property));
                        written = true;
                    } else if (property instanceof InputStream) {
                        try (InputStream stream = (InputStream)property;){
                            ByteStreams.copy(stream, (OutputStream)response.getOutputStream());
                            written = true;
                        }
                    } else {
                        log.warn("configured property {} found, but type {} is not String or Binary.", (Object)absoluteRobotsContentsPropertyPath, property.getClass());
                    }
                } else {
                    log.warn("configured property {} does not exist below {}.", (Object)propertyName, (Object)resourcePath);
                }
            } else {
                log.warn("configured resource {} does not exist.", (Object)resourcePath);
            }
        }
        if (!written) {
            log.error("no response was written while processing robots with jcr property {}.", (Object)absoluteRobotsContentsPropertyPath);
            response.sendError(404);
        }
    }

    private String buildUserAgentsDirective(String agent) {
        return USER_AGENT + agent;
    }

    private String buildCrawlerDelay() {
        if (this.crawlDelay > 0) {
            return CRAWL_DELAY + String.valueOf(this.crawlDelay);
        }
        return "";
    }

    private void addCrawlDelay(PrintWriter writer) {
        String crawlDelayString = this.buildCrawlerDelay();
        if (StringUtils.isNotBlank((CharSequence)crawlDelayString)) {
            writer.println(crawlDelayString);
        }
    }

    private String buildSitemapDirective(String sitemap, SlingHttpServletRequest request, PageManager pageManager, ResourceResolver resourceResolver) {
        Page page;
        String sitemapPagePath = sitemap;
        if (!sitemapPagePath.startsWith("/")) {
            Page currentPage = pageManager.getContainingPage(request.getResource());
            sitemapPagePath = Text.fullFilePath((String)currentPage.getPath(), (String)sitemap);
        }
        if ((page = pageManager.getContainingPage(sitemapPagePath)) != null) {
            log.debug("Found page at {}. Generate sitemap directive based on that.", (Object)sitemapPagePath);
            sitemap = this.getSitemapUrl(request, page, resourceResolver);
        }
        return SITEMAP + sitemap;
    }

    private String getSitemapUrl(SlingHttpServletRequest request, Page page, ResourceResolver resourceResolver) {
        String sitemapRule;
        String sitemapRequestPath = page.getPath() + ".sitemap.xml";
        if (StringUtils.isNotBlank((CharSequence)this.externalizerDomain)) {
            log.debug("No externalizer domain configured, take into account current host header {} and current scheme {}", (Object)request.getServerName(), (Object)request.getScheme());
            sitemapRule = this.externalizer.externalLink(resourceResolver, this.externalizerDomain, sitemapRequestPath);
        } else {
            sitemapRule = this.externalizer.absoluteLink(request, request.getScheme(), sitemapRequestPath);
        }
        return sitemapRule;
    }

    private String buildAllowedOrDisallowedDirective(boolean isAllowed, String allowedOrDisallowedRule, PageManager pageManager, ResourceResolver resourceResolver, boolean generatePagePath) {
        Page page = pageManager.getContainingPage(allowedOrDisallowedRule);
        if (page != null) {
            allowedOrDisallowedRule = !generatePagePath ? resourceResolver.map(page.getPath()) + "/" : resourceResolver.map(page.getPath()) + ".html";
        }
        return (isAllowed ? ALLOW : DISALLOW) + allowedOrDisallowedRule;
    }

    @ObjectClassDefinition(name="ACS AEM Commons - Robots Servlet")
    protected static @interface RobotsServletConfig {
        @AttributeDefinition(name="Web-Console Configuration Name Hint")
        public String webconsole_configurationFactory_nameHint() default "Robots.txt for resource types: [{sling.servlet.resourceTypes}]";

        @AttributeDefinition(name="Sling Resource Type", description="Sling Resource Type for the Home Page component or components.")
        public String[] sling_servlet_resourceTypes() default {};

        @AttributeDefinition(name="Robots Content Property", description="Path (either relative or absolute) to a String or Binary property containing the entire robots.txt contents. This could be a page property (e.g. robotsTxtContents) or the contents of a file within the DAM (e.g. /content/dam/my-site/seo/robots.txt/jcr:content/renditions/original/jcr:content/jcr:data). If this is specified, all other configurations are effectively ignored.")
        public String robots_content_property_path();

        @AttributeDefinition(name="User Agent Directives", description="A set of User-agent directives to add to the robots file. Each directive is optionally pre-fixed with a ruleGroupName. Syntax: [<ruleGroupName>:]<user agent name>")
        public String[] user_agent_directives() default {};

        @AttributeDefinition(name="Allow Directives", description="A set of Allow directives to add to the robots file. Each directive is optionally pre-fixed with a ruleGroupName. Syntax: [<ruleGroupName>:]<allowed path>. If the specified path is a valid cq page, resourceResolver.map() will be called prior to adding the rule.")
        public String[] allow_directives() default {};

        @AttributeDefinition(name="Allow Path Property Names", description="A list of boolean page properties which enable generation of an allow directive for that path. Any directives added through this method are in addition to those specified in the allow.directives property. Each property name is optionally pre-fixed with a ruleGroupName. Syntax: [<ruleGroupName>:]<propertyName>")
        public String[] allow_property_names() default {};

        @AttributeDefinition(name="Allow Page Property Names", description="A list of boolean page properties which enable generation of an allow directive for that page. Any directives added through this method are in addition to those specified in the allow.directives property. Each property name is optionally pre-fixed with a ruleGroupName. Syntax: [<ruleGroupName>:]<propertyName>")
        public String[] allow_page_property_names() default {};

        @AttributeDefinition(name="Disallow Directives", description="A set of Disallow directives to add to the robots file. Each directive is optionally pre-fixed with a ruleGroupName. Syntax: [<ruleGroupName>:]<disallowed path>. If the specified path is a valid cq page, resourceResolver.map() will be called prior to adding the rule.")
        public String[] disallow_directives() default {};

        @AttributeDefinition(name="Disallow Path Property Names", description="A list of boolean page properties wich enable generation of a disallow directive for that path. Any directives added through this method are in addition to those specified in the disallowed.directives property. Each property name is optionally pre-fixed with a ruleGroupName. Syntax: [<ruleGroupName>:]<propertyName>")
        public String[] disallow_property_names() default {};

        @AttributeDefinition(name="Disallow Page Property Names", description="A list of boolean page properties wich enable generation of a disallow directive for that page. Any directives added through this method are in addition to those specified in the disallowed.directives property. Each property name is optionally pre-fixed with a ruleGroupName. Syntax: [<ruleGroupName>:]<propertyName>")
        public String[] disallow_page_property_names() default {};

        @AttributeDefinition(name="Sitemap Directives", description="A set of Sitemap directives to add to the robots file. If the specified path is a valid AEM page path (either absolute or relative to the current page), externalizer is called with the specified Externalizer Domain to generate an absolute url to that page's .sitemap.xml, which will resolve to the ACS Commons Site Map Servlet.")
        public String[] sitemap_directives() default {};

        @AttributeDefinition(name="Sitemap Property Names", description="A list of boolean page properties which enable generation of the sitemap directive for that page. Any directives added through this method are in addition to those specified in the sitemap.directives property.")
        public String[] sitemap_property_names() default {};

        @AttributeDefinition(name="Externalizer Domain", description="Must correspond to a configuration of the Externalizer component. If blank the externalization will prepend the current request's scheme combined with the current request's host header.")
        public String externalizer_domain() default "publish";

        @AttributeDefinition(name="Print Grouping Comments", description="When enabled, comments are printed to the file for start and end of each rule group. This is primarily for debugging purposes.")
        public boolean print_grouping_comments() default false;

        @AttributeDefinition(name="Crawl Delay", description="Specify the crawl delay in seconds, the crawler will wait for the amount of seconds before crawling")
        public int crawl_delay() default 0;
    }

    private class RobotsRuleSet {
        private static final String GROUP_NAME_DEFAULT = "RobotsServletDefaultGroup";
        private List<String> sitemaps;
        private List<String> sitemapProperties;
        private Map<String, RobotsRuleGroup> groups;

        public RobotsRuleSet(RobotsServletConfig config) {
            this.sitemaps = Arrays.asList(config.sitemap_directives());
            this.sitemapProperties = Arrays.asList(config.sitemap_property_names());
            this.groups = new LinkedHashMap<String, RobotsRuleGroup>();
            String[] userAgents = config.user_agent_directives();
            this.processConfig(userAgents, group -> ((RobotsRuleGroup)group).userAgents);
            String[] allowed = config.allow_directives();
            this.processConfig(allowed, group -> ((RobotsRuleGroup)group).allowed);
            String[] disallowed = config.disallow_directives();
            this.processConfig(disallowed, group -> ((RobotsRuleGroup)group).disallowed);
            String[] disallowPathProps = config.disallow_property_names();
            this.processConfig(disallowPathProps, group -> ((RobotsRuleGroup)group).disallowPathProperties);
            String[] disallowPageProps = config.disallow_page_property_names();
            this.processConfig(disallowPageProps, group -> ((RobotsRuleGroup)group).disallowPageProperties);
            String[] allowPathProps = config.allow_property_names();
            this.processConfig(allowPathProps, group -> ((RobotsRuleGroup)group).allowPathProperties);
            String[] allowPageProps = config.allow_page_property_names();
            this.processConfig(allowPageProps, group -> ((RobotsRuleGroup)group).allowPageProperties);
        }

        private void processConfig(String[] configs, Function<RobotsRuleGroup, List<String>> configListGetFunc) {
            for (String config : configs) {
                Pair<String, String> groupNamePair = this.getGroupNameTuple(config);
                String groupName = (String)groupNamePair.getKey();
                String value = (String)groupNamePair.getValue();
                RobotsRuleGroup group = this.getRobotsRuleGroup(groupName);
                configListGetFunc.apply(group).add(value);
                this.groups.put(groupName, group);
            }
        }

        private RobotsRuleGroup getRobotsRuleGroup(String groupName) {
            RobotsRuleGroup group = this.groups.get(groupName);
            if (group == null) {
                group = new RobotsRuleGroup();
                group.groupName = groupName;
            }
            return group;
        }

        private Pair<String, String> getGroupNameTuple(String configValue) {
            String groupName = GROUP_NAME_DEFAULT;
            String value = configValue;
            String[] split = configValue.split(":");
            if (split.length > 1) {
                groupName = split[0];
                value = split[1];
            }
            return new ImmutablePair((Object)groupName, (Object)value);
        }

        public List<String> getSitemaps() {
            return Collections.unmodifiableList(this.sitemaps);
        }

        public List<String> getSitemapProperties() {
            return Collections.unmodifiableList(this.sitemapProperties);
        }

        public List<RobotsRuleGroup> getGroups() {
            return new ArrayList<RobotsRuleGroup>(this.groups.values());
        }
    }

    private class RobotsRuleGroup {
        private String groupName;
        private List<String> userAgents = new ArrayList<String>();
        private List<String> allowed = new ArrayList<String>();
        private List<String> disallowed = new ArrayList<String>();
        private List<String> allowPathProperties = new ArrayList<String>();
        private List<String> allowPageProperties = new ArrayList<String>();
        private List<String> disallowPathProperties = new ArrayList<String>();
        private List<String> disallowPageProperties = new ArrayList<String>();

        private RobotsRuleGroup() {
        }

        public String getGroupName() {
            return this.groupName;
        }

        public List<String> getUserAgents() {
            return Collections.unmodifiableList(this.userAgents);
        }

        public List<String> getAllowed() {
            return Collections.unmodifiableList(this.allowed);
        }

        public List<String> getDisallowed() {
            return Collections.unmodifiableList(this.disallowed);
        }

        public List<String> getAllowPathProperties() {
            return Collections.unmodifiableList(this.allowPathProperties);
        }

        public List<String> getAllowPageProperties() {
            return Collections.unmodifiableList(this.allowPageProperties);
        }

        public List<String> getDisallowPathProperties() {
            return Collections.unmodifiableList(this.disallowPathProperties);
        }

        public List<String> getDisallowPageProperties() {
            return Collections.unmodifiableList(this.disallowPageProperties);
        }
    }
}

