/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.config.impl.keys;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.exception.HttpCacheKeyCreationException;
import com.adobe.acs.commons.httpcache.keys.AbstractCacheKey;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.httpcache.keys.CacheKeyFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.sling.api.SlingHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedCacheKey
extends AbstractCacheKey
implements CacheKey,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(CombinedCacheKey.class);
    private LinkedList<CacheKey> cacheKeys;

    public CombinedCacheKey(SlingHttpServletRequest request, HttpCacheConfig cacheConfig, List<CacheKeyFactory> cacheKeyFactories) {
        super(request, cacheConfig);
        this.cacheKeys = cacheKeyFactories.stream().map(factory -> this.createCacheKey(request, cacheConfig, (CacheKeyFactory)factory)).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedList::new));
    }

    public CombinedCacheKey(String uri, HttpCacheConfig cacheConfig, List<CacheKeyFactory> cacheKeyFactories) {
        super(uri, cacheConfig);
        this.cacheKeys = cacheKeyFactories.stream().map(factory -> this.createCacheKey(uri, cacheConfig, (CacheKeyFactory)factory)).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    public boolean equals(Object o) {
        boolean selfCheck = super.equals(o);
        if (!selfCheck) {
            return false;
        }
        CombinedCacheKey other = (CombinedCacheKey)o;
        if (other == null) {
            return false;
        }
        for (int i = 0; i < this.cacheKeys.size(); ++i) {
            CacheKey ownDelegate;
            CacheKey otherDelegate = other.getDelegate(i);
            if (otherDelegate.equals(ownDelegate = this.getDelegate(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getUri()).append((Object)this.getAuthenticationRequirement()).toHashCode();
    }

    private CacheKey createCacheKey(SlingHttpServletRequest request, HttpCacheConfig cacheConfig, CacheKeyFactory factory) {
        try {
            return factory.build(request, cacheConfig);
        }
        catch (HttpCacheKeyCreationException e) {
            log.error("Error creating cache key: ", (Throwable)e);
            return null;
        }
    }

    private CacheKey createCacheKey(String resourcePath, HttpCacheConfig cacheConfig, CacheKeyFactory factory) {
        try {
            return factory.build(resourcePath, cacheConfig);
        }
        catch (HttpCacheKeyCreationException e) {
            log.error("Error creating cache key: ", (Throwable)e);
            return null;
        }
    }

    private CacheKey getDelegate(int position) {
        return this.cacheKeys.get(position);
    }

    @Override
    public String toString() {
        return this.resourcePath + "[CombinedCacheKey]" + this.cacheKeys.stream().map(CacheKey::toString).collect(Collectors.joining(";")).replaceAll(this.resourcePath, "");
    }

    private void writeObject(ObjectOutputStream o) throws IOException {
        this.parentWriteObject(o);
        o.writeObject(this.cacheKeys);
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        this.parentReadObject(o);
        this.cacheKeys = (LinkedList)o.readObject();
    }
}

