/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.contentsync;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import java.lang.invoke.MethodHandles;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class SyncHostConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @ValueMapValue(injectionStrategy=InjectionStrategy.REQUIRED)
    private String host;
    @ValueMapValue
    private String username;
    @ValueMapValue
    private String password;
    @OSGiService
    private CryptoSupport crypto;

    public String getHost() {
        return this.host;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        if (this.crypto.isProtected(this.password)) {
            try {
                this.password = this.crypto.unprotect(this.password);
            }
            catch (CryptoException e) {
                log.error("Error while un-protecting password: {}", (Object)this.password, (Object)e);
            }
        }
        return this.password;
    }
}

