/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.dam.audio.watson.impl;

import com.adobe.acs.commons.dam.audio.impl.AudioException;
import com.adobe.acs.commons.dam.audio.impl.AudioHelper;
import com.adobe.acs.commons.dam.audio.watson.impl.TranscriptionService;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowExternalProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.dam.handler.ffmpeg.ExecutableLocator;
import com.day.cq.dam.handler.ffmpeg.FFMpegWrapper;
import com.day.cq.dam.video.VideoProfile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="ACS AEM Commons - Watson Transcription Workflow Process", description="ACS AEM Commons - Watson Transcription Workflow Process")
@Service(value={WorkflowExternalProcess.class})
@Property(name="process.name", value={"Generate Audio Transcript with IBM Watson"}, propertyPrivate=true)
public class TranscriptionProcess
implements WorkflowExternalProcess,
AudioHelper.AudioProcessor<MetaDataMap, Serializable> {
    private static final Logger log = LoggerFactory.getLogger(TranscriptionProcess.class);
    @Reference
    private TranscriptionService transcriptionService;
    @Reference
    private AudioHelper audioHelper;
    private static final String DEFAULT_PROFILE = "flacmono";
    @Property(label="Trancode Profile", description="Profile name for audio transcoding. Must be a format acceptable to Watson", value={"flacmono"})
    private static final String PROP_PROFILE = "profile";
    private String profileName;

    @Activate
    protected void activate(Map<String, Object> config) {
        this.profileName = PropertiesUtil.toString((Object)config.get(PROP_PROFILE), (String)DEFAULT_PROFILE);
    }

    public Serializable execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
        ResourceResolver resolver = (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
        Asset asset = this.getAssetFromPayload(workItem, resolver);
        if (asset == null) {
            return null;
        }
        String mimeType = asset.getMimeType();
        if (!mimeType.startsWith("video/") && !mimeType.startsWith("audio/")) {
            return null;
        }
        try {
            Serializable jobId = this.audioHelper.process(asset, resolver, metaDataMap, this);
            if (jobId != null) {
                return jobId;
            }
            return null;
        }
        catch (AudioException e) {
            throw new WorkflowException("Unable to start transcription process.", (Throwable)e);
        }
    }

    @Override
    public Serializable processAudio(Asset asset, ResourceResolver resourceResolver, File tempFile, ExecutableLocator locator, File workingDir, MetaDataMap args) throws AudioException {
        long start = System.currentTimeMillis();
        String jobId = null;
        log.info("processing asset [{}]...", (Object)asset.getPath());
        VideoProfile profile = VideoProfile.get((ResourceResolver)resourceResolver, (String)this.profileName);
        if (profile != null) {
            log.info("processAudio: creating audio using profile [{}]", (Object)this.profileName);
            FFMpegWrapper ffmpegWrapper = FFMpegWrapper.fromProfile((File)tempFile, (VideoProfile)profile, (File)workingDir);
            ffmpegWrapper.setExecutableLocator(locator);
            try {
                File transcodedAudio = ffmpegWrapper.transcode();
                FileInputStream stream = new FileInputStream(transcodedAudio);
                jobId = this.transcriptionService.startTranscriptionJob(stream, ffmpegWrapper.getOutputMimetype());
                IOUtils.closeQuietly((InputStream)stream);
                try {
                    Files.delete(transcodedAudio.toPath());
                }
                catch (IOException e) {
                    log.error("Transcoded audio file @ " + transcodedAudio.getAbsolutePath() + " coud not be deleted", (Throwable)e);
                }
            }
            catch (IOException e) {
                log.error("processAudio: failed creating audio from profile [{}]: {}", (Object)this.profileName, (Object)e.getMessage());
            }
        }
        if (log.isInfoEnabled()) {
            long time = System.currentTimeMillis() - start;
            log.info("finished initial processing of asset [{}] in [{}ms].", (Object)asset.getPath(), (Object)time);
        }
        return jobId;
    }

    public boolean hasFinished(Serializable serializable, WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) {
        if (serializable == null) {
            return true;
        }
        ResourceResolver resolver = (ResourceResolver)workflowSession.adaptTo(ResourceResolver.class);
        Asset asset = this.getAssetFromPayload(workItem, resolver);
        if (asset == null) {
            log.error("job started, but asset no longer exists.");
            return true;
        }
        if (serializable instanceof String) {
            TranscriptionService.Result result = this.transcriptionService.getResult((String)((Object)serializable));
            if (result.isCompleted()) {
                try {
                    asset.addRendition("transcription.txt", (InputStream)new ByteArrayInputStream(result.getContent().getBytes("UTF-8")), "text/plain");
                    log.info("Transcription for {} created.", (Object)asset.getPath());
                }
                catch (UnsupportedEncodingException e) {
                    log.error("Unable to save new rendition", (Throwable)e);
                }
                return true;
            }
            return false;
        }
        log.error("Unexpected serializable {}", (Object)serializable);
        return true;
    }

    public void handleResult(Serializable serializable, WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) throws WorkflowException {
    }

    private Asset getAssetFromPayload(WorkItem item, ResourceResolver resourceResolver) {
        if (item.getWorkflowData().getPayloadType().equals("JCR_PATH")) {
            String path = item.getWorkflowData().getPayload().toString();
            Resource resource = resourceResolver.getResource(path);
            if (resource != null) {
                return DamUtil.resolveToAsset((Resource)resource);
            }
            log.error("Resource [{}] in payload of workflow [{}] does not exist.", (Object)path, (Object)item.getWorkflow().getId());
        }
        return null;
    }

    protected void bindTranscriptionService(TranscriptionService transcriptionService) {
        this.transcriptionService = transcriptionService;
    }

    protected void unbindTranscriptionService(TranscriptionService transcriptionService) {
        if (this.transcriptionService == transcriptionService) {
            this.transcriptionService = null;
        }
    }

    protected void bindAudioHelper(AudioHelper audioHelper) {
        this.audioHelper = audioHelper;
    }

    protected void unbindAudioHelper(AudioHelper audioHelper) {
        if (this.audioHelper == audioHelper) {
            this.audioHelper = null;
        }
    }
}

