/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.event.propertytypes.EventTopics;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE)
@EventTopics(value={"org/osgi/framework/BundleEvent/STARTED", "org/osgi/framework/ServiceEvent/REGISTERED"})
@Designate(ocd=Config.class)
public class ComponentDisabler
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(ComponentDisabler.class);
    private final BundleContext bundleContext;
    private final ServiceComponentRuntime scr;
    private final Set<String> disabledComponents;

    @Activate
    public ComponentDisabler(BundleContext bundleContext, Config config, @Reference ServiceComponentRuntime scr, @Reference(policyOption=ReferencePolicyOption.GREEDY) List<ConfigAmendment> configAmendments) {
        this.bundleContext = bundleContext;
        this.disabledComponents = new HashSet<String>();
        this.disabledComponents.addAll(Arrays.asList(config.components()));
        configAmendments.stream().forEach(amendment -> this.disabledComponents.addAll(Arrays.asList(amendment.getConfig().components())));
        this.scr = scr;
        this.handleEvent(null);
    }

    public void handleEvent(Event event) {
        log.trace("Disabling OSGi DS components {}", (Object)String.join((CharSequence)",", this.disabledComponents));
        for (String component : this.disabledComponents) {
            this.disable(component);
        }
    }

    public void disable(String componentName) {
        for (Bundle bundle : this.bundleContext.getBundles()) {
            ComponentDescriptionDTO dto = this.scr.getComponentDescriptionDTO(bundle, componentName);
            if (dto == null || !this.scr.isComponentEnabled(dto)) continue;
            log.info("Disabling OSGi DS Component {}.", (Object)dto.implementationClass);
            this.scr.disableComponent(dto);
        }
    }

    @ObjectClassDefinition(name="ACS AEM Commons - OSGi DS Component Disabler", description="Disables OSGi DS components by configuration")
    static @interface Config {
        @AttributeDefinition(name="Disabled components", description="The names of the components you want to disable (usually their fully class name)", cardinality=0x7FFFFFFF)
        public String[] components();
    }

    @Component(service={ConfigAmendment.class}, property={"webconsole.configurationFactory.nameHint={components}"})
    @Designate(factory=true, ocd=Config.class)
    public static final class ConfigAmendment {
        private final Config config;

        @Activate
        public ConfigAmendment(Config config) {
            this.config = config;
        }

        public Config getConfig() {
            return this.config;
        }
    }
}

