/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.properties.shared.impl;

import com.adobe.acs.commons.wcm.PageRootProvider;
import com.adobe.acs.commons.wcm.properties.shared.SharedComponentProperties;
import com.adobe.acs.commons.wcm.properties.shared.SharedValueMapResourceAdapter;
import com.adobe.acs.commons.wcm.properties.shared.impl.SharedValueMapResourceAdapterImpl;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE)
@Service(value={SharedComponentProperties.class, AdapterFactory.class})
@Properties(value={@Property(name="adaptables", classValue={Resource.class}), @Property(name="adapters", classValue={SharedValueMapResourceAdapter.class})})
public class SharedComponentPropertiesImpl
implements SharedComponentProperties,
AdapterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SharedComponentPropertiesImpl.class);
    private static final String INFIX_JCR_CONTENT = "/jcr:content/";
    @Reference(policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    PageRootProvider pageRootProvider;

    static String getCanonicalResourceTypeRelativePath(String resourceType, String[] searchPaths) {
        if (StringUtils.isEmpty((CharSequence)resourceType) || resourceType.contains(":")) {
            return null;
        }
        if (resourceType.charAt(0) != '/') {
            return resourceType;
        }
        if (searchPaths != null) {
            for (String searchPath : searchPaths) {
                if (!resourceType.startsWith(searchPath)) continue;
                return resourceType.substring(searchPath.length());
            }
        }
        return null;
    }

    @Override
    public String getSharedPropertiesPagePath(Resource resource) {
        if (this.pageRootProvider != null) {
            if (resource != null) {
                String pagePath = this.pageRootProvider.getRootPagePath(resource.getPath());
                if (StringUtils.isNotBlank((CharSequence)pagePath)) {
                    return pagePath;
                }
                LOG.debug("Could not determine shared properties page for resource {}", (Object)resource.getPath());
            }
        } else {
            LOG.debug("Page Root Provider must be configured for shared component properties to be supported");
        }
        return null;
    }

    @Override
    public String getGlobalPropertiesPath(Resource resource) {
        String rootPagePath = this.getSharedPropertiesPagePath(resource);
        if (StringUtils.isNotBlank((CharSequence)rootPagePath)) {
            return rootPagePath + INFIX_JCR_CONTENT + "global-component-properties";
        }
        return null;
    }

    @Override
    public ValueMap getGlobalProperties(Resource resource) {
        if (resource == null) {
            return ValueMap.EMPTY;
        }
        return Optional.ofNullable(this.getGlobalPropertiesPath(resource)).map(arg_0 -> ((ResourceResolver)resource.getResourceResolver()).getResource(arg_0)).map(Resource::getValueMap).orElse(ValueMap.EMPTY);
    }

    @Override
    public String getSharedPropertiesPath(Resource resource) {
        String rootPagePath = this.getSharedPropertiesPagePath(resource);
        if (StringUtils.isBlank((CharSequence)rootPagePath)) {
            return null;
        }
        String resourceTypeRelativePath = SharedComponentPropertiesImpl.getCanonicalResourceTypeRelativePath(resource.getResourceType(), resource.getResourceResolver().getSearchPath());
        if (resourceTypeRelativePath != null) {
            return rootPagePath + INFIX_JCR_CONTENT + "shared-component-properties" + "/" + resourceTypeRelativePath;
        }
        return null;
    }

    @Override
    public ValueMap getSharedProperties(Resource resource) {
        if (resource == null) {
            return ValueMap.EMPTY;
        }
        return Optional.ofNullable(this.getSharedPropertiesPath(resource)).map(arg_0 -> ((ResourceResolver)resource.getResourceResolver()).getResource(arg_0)).map(Resource::getValueMap).orElse(ValueMap.EMPTY);
    }

    @Override
    public ValueMap mergeProperties(ValueMap globalProperties, ValueMap sharedProperties, Resource resource) {
        HashMap mergedProperties = new HashMap();
        if (globalProperties != null) {
            mergedProperties.putAll(globalProperties);
        }
        if (sharedProperties != null) {
            mergedProperties.putAll(sharedProperties);
        }
        if (resource != null) {
            mergedProperties.putAll(resource.getValueMap());
        }
        return new ValueMapDecorator(mergedProperties);
    }

    @Nullable
    public <AdapterType> AdapterType getAdapter(@NotNull Object adaptable, @NotNull Class<AdapterType> adapterType) {
        if (adaptable instanceof Resource && adapterType == SharedValueMapResourceAdapter.class) {
            return (AdapterType)this.getSharedValueMapResourceAdapter((Resource)adaptable);
        }
        return null;
    }

    @NotNull
    SharedValueMapResourceAdapter getSharedValueMapResourceAdapter(@NotNull Resource adaptable) {
        ValueMap globalProperties = this.getGlobalProperties(adaptable);
        ValueMap sharedProperties = this.getSharedProperties(adaptable);
        ValueMap mergedProperties = this.mergeProperties(globalProperties, sharedProperties, adaptable);
        return new SharedValueMapResourceAdapterImpl(globalProperties, sharedProperties, mergedProperties);
    }

    protected void bindPageRootProvider(PageRootProvider pageRootProvider) {
        this.pageRootProvider = pageRootProvider;
    }

    protected void unbindPageRootProvider(PageRootProvider pageRootProvider) {
        if (this.pageRootProvider == pageRootProvider) {
            this.pageRootProvider = null;
        }
    }
}

