/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.dispatcher.impl;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Permission Sensitive Cache Servlet", description="Servlet that checks if the current sessions has access to a cached object", metatype=true, immediate=true)
@Properties(value={@Property(name="sling.servlet.paths", cardinality=0x7FFFFFFF, label="Sling Servlet Paths", description="Paths that this servlet will resolve to")})
@Service
public class PermissionSensitiveCacheServlet
extends SlingSafeMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(PermissionSensitiveCacheServlet.class);

    public void doHead(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        try {
            ResourceResolver resourceResolver = request.getResourceResolver();
            String requestUri = request.getParameter("uri");
            this.log.debug("Checking access for URI {}", (Object)requestUri);
            if (this.isUriValid(requestUri)) {
                Resource requestedResource = resourceResolver.resolve((HttpServletRequest)request, requestUri);
                if (!ResourceUtil.isNonExistingResource((Resource)requestedResource)) {
                    this.log.debug("Current Session has access to {}", (Object)requestUri);
                    response.setStatus(200);
                } else {
                    this.log.info("Current Session does not have access to {}", (Object)requestUri);
                    response.setStatus(401);
                }
            } else {
                this.log.debug("Invalid URI {}", (Object)requestUri);
                response.setStatus(401);
            }
        }
        catch (Exception e) {
            this.log.error("Authchecker servlet exception", (Throwable)e);
            response.setStatus(401);
        }
    }

    public boolean isUriValid(String requestUri) {
        boolean isValidUri = true;
        if (!StringUtils.startsWith((CharSequence)requestUri, (CharSequence)"/")) {
            isValidUri = false;
        }
        return isValidUri;
    }
}

