/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.fam.actions;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.actions.Actions;
import com.adobe.acs.commons.functions.CheckedConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionBatch
extends LinkedBlockingQueue<CheckedConsumer<ResourceResolver>> {
    private static final Logger LOG = LoggerFactory.getLogger(ActionBatch.class);
    private final ActionManager manager;
    private int retryCount = 5;
    private long retryDelay = 100L;

    public ActionBatch(ActionManager manager, int capacity) {
        super(capacity);
        this.manager = manager;
    }

    public void setRetryCount(int count) {
        this.retryCount = count;
    }

    public void setRetryWait(long delay) {
        this.retryDelay = delay;
    }

    @Override
    public boolean add(CheckedConsumer<ResourceResolver> c) {
        if (this.remainingCapacity() == 0) {
            this.commitBatch();
        }
        super.add(c);
        if (this.remainingCapacity() == 0) {
            this.commitBatch();
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends CheckedConsumer<ResourceResolver>> c) {
        c.forEach(this::add);
        return true;
    }

    public void commitBatch() {
        ArrayList consumers = new ArrayList();
        int count = this.drainTo(consumers);
        if (count > 0) {
            this.manager.deferredWithResolver(Actions.retry(this.retryCount, this.retryDelay, rr -> {
                LOG.info("Executing {} actions", (Object)count);
                for (CheckedConsumer consumer : consumers) {
                    consumer.accept(rr);
                }
                LOG.info("Commiting {} actions", (Object)count);
                rr.commit();
                LOG.info("Commit successful");
            }));
        }
    }
}

