/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.fam.impl;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.ActionManagerFactory;
import com.adobe.acs.commons.fam.ThrottledTaskRunner;
import com.adobe.acs.commons.fam.impl.ActionManagerImpl;
import com.adobe.acs.commons.fam.mbean.ActionManagerMBean;
import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularDataSupport;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;

@Component
@Service(value={ActionManagerFactory.class})
@Property(name="jmx.objectname", value={"com.adobe.acs.commons:type=Action Manager"})
public class ActionManagerFactoryImpl
extends AnnotatedStandardMBean
implements ActionManagerFactory {
    @Reference
    ThrottledTaskRunner taskRunner;
    private final Map<String, ActionManager> tasks = Collections.synchronizedMap(new LinkedHashMap());

    public ActionManagerFactoryImpl() throws NotCompliantMBeanException {
        super(ActionManagerMBean.class);
    }

    @Override
    public ActionManager createTaskManager(String name, ResourceResolver resourceResolver, int saveInterval) throws LoginException {
        String fullName = String.format("%s (%s)", name, UUID.randomUUID().toString());
        ActionManagerImpl manager = new ActionManagerImpl(fullName, this.taskRunner, resourceResolver, saveInterval);
        this.tasks.put(fullName, manager);
        return manager;
    }

    @Override
    public ActionManager getActionManager(String name) {
        if (name == null) {
            return null;
        }
        return this.tasks.get(name);
    }

    @Override
    public boolean hasActionManager(String name) {
        return this.tasks.get(name) != null;
    }

    @Override
    public TabularDataSupport getStatistics() throws OpenDataException {
        TabularDataSupport stats = new TabularDataSupport(ActionManagerImpl.getStaticsTableType());
        for (ActionManager task : this.tasks.values()) {
            stats.put(task.getStatistics());
        }
        return stats;
    }

    @Override
    public TabularDataSupport getFailures() throws OpenDataException {
        TabularDataSupport stats = new TabularDataSupport(ActionManagerImpl.getFailuresTableType());
        for (ActionManager task : this.tasks.values()) {
            stats.putAll(task.getFailures().toArray(new CompositeData[0]));
        }
        return stats;
    }

    @Override
    public void purgeCompletedTasks() {
        Iterator<ActionManager> taskIterator = this.tasks.values().iterator();
        while (taskIterator.hasNext()) {
            ActionManager task = taskIterator.next();
            if (!task.isComplete() && this.taskRunner.getActiveCount() != 0L) continue;
            task.closeAllResolvers();
            taskIterator.remove();
        }
    }

    @Override
    public void purge(ActionManager manager) {
        if (!manager.isComplete()) {
            manager.cancel(true);
        }
        manager.closeAllResolvers();
        this.tasks.values().remove(manager);
    }

    protected void bindTaskRunner(ThrottledTaskRunner throttledTaskRunner) {
        this.taskRunner = throttledTaskRunner;
    }

    protected void unbindTaskRunner(ThrottledTaskRunner throttledTaskRunner) {
        if (this.taskRunner == throttledTaskRunner) {
            this.taskRunner = null;
        }
    }
}

