/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.functions;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobin<T>
implements Iterable<T> {
    private final List<T> items;

    public RoundRobin(List<T> coll) {
        this.items = coll;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final AtomicInteger index = new AtomicInteger(0);

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public synchronized T next() {
                int idx = this.index.getAndIncrement() % RoundRobin.this.items.size();
                return RoundRobin.this.items.get(idx);
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException("remove not allowed");
            }
        };
    }
}

