/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.http.headers.impl;

import com.adobe.acs.commons.http.headers.impl.AbstractDispatcherCacheHeaderFilter;
import java.util.Dictionary;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;

@Component(label="ACS AEM Commons - Dispacher Cache Control Header - Max Age", description="Adds a Cache-Control max-age header to content to enable Dispatcher TTL support.", metatype=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(label="Filter Patterns", description="Patterns on which to apply this Max Age cache-control rule.", cardinality=0x7FFFFFFF, name="filter.pattern", propertyPrivate=false, value={}), @Property(name="webconsole.configurationFactory.nameHint", value={"Max Age: {max.age} for Patterns: [{filter.pattern}]"}, propertyPrivate=true)})
public class DispatcherMaxAgeHeaderFilter
extends AbstractDispatcherCacheHeaderFilter {
    protected static final String CACHE_CONTROL_NAME = "Cache-Control";
    @Property(label="Cache-Control Max Age", description="Max age value (in seconds) to put in Cache Control header.")
    public static final String PROP_MAX_AGE = "max.age";
    private static final String HEADER_PREFIX = "max-age=";
    private long maxage;

    @Override
    protected String getHeaderName() {
        return CACHE_CONTROL_NAME;
    }

    @Override
    protected String getHeaderValue() {
        return HEADER_PREFIX + this.maxage;
    }

    @Override
    protected void doActivate(ComponentContext context) throws Exception {
        Dictionary properties = context.getProperties();
        this.maxage = PropertiesUtil.toLong(properties.get(PROP_MAX_AGE), (long)-1L);
        if (this.maxage < 0L) {
            throw new ConfigurationException(PROP_MAX_AGE, "Max Age must be specified and greater than 0.");
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getHeaderValue() + "]";
    }
}

