/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.config.impl;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.config.HttpCacheConfigExtension;
import com.adobe.acs.commons.httpcache.exception.HttpCacheKeyCreationException;
import com.adobe.acs.commons.httpcache.exception.HttpCacheRepositoryAccessException;
import com.adobe.acs.commons.httpcache.keys.AbstractCacheKey;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.httpcache.keys.CacheKeyFactory;
import com.adobe.acs.commons.util.ParameterUtil;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - HTTP Cache - ResourceType based extension for HttpCacheConfig and CacheKeyFactory.", metatype=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(name="webconsole.configurationFactory.nameHint", value={"Allowed resource types: {httpcache.config.extension.resource-types.allowed}"}, propertyPrivate=true)})
@Service
public class ResourceTypeHttpCacheConfigExtension
implements HttpCacheConfigExtension,
CacheKeyFactory {
    private static final Logger log = LoggerFactory.getLogger(ResourceTypeHttpCacheConfigExtension.class);
    @Property(label="Allowed paths", description="Regex of content paths that can be cached.", unbounded=PropertyUnbounded.ARRAY)
    private static final String PROP_PATHS = "httpcache.config.extension.paths.allowed";
    private List<Pattern> pathPatterns;
    @Property(label="Allowed resource types", description="Regex of resource types that can be cached.", unbounded=PropertyUnbounded.ARRAY)
    private static final String PROP_RESOURCE_TYPES = "httpcache.config.extension.resource-types.allowed";
    private List<Pattern> resourceTypePatterns;
    @Property(label="Check RT of ./jcr:content?", description="Should the resourceType check be applied to ./jcr:content ?", boolValue={false})
    public static final String PROP_CHECK_CONTENT_RESOURCE_TYPE = "httpcache.config.extension.resource-types.page-content";
    private boolean checkContentResourceType;

    @Override
    public boolean accepts(SlingHttpServletRequest request, HttpCacheConfig cacheConfig) throws HttpCacheRepositoryAccessException {
        if (log.isDebugEnabled()) {
            log.debug("ResourceType acceptance check on [ {} ~> {} ]", (Object)request.getResource(), (Object)request.getResource().getResourceType());
        }
        for (Pattern pattern : this.pathPatterns) {
            Matcher m = pattern.matcher(request.getResource().getPath());
            if (m.matches()) continue;
            return false;
        }
        Resource candidateResource = request.getResource();
        if (this.checkContentResourceType && (candidateResource = candidateResource.getChild("jcr:content")) == null) {
            return false;
        }
        log.debug("ResourceHttpCacheConfigExtension checking for resource type matches");
        for (Pattern pattern : this.resourceTypePatterns) {
            Matcher m = pattern.matcher(candidateResource.getResourceType());
            if (!m.matches()) continue;
            if (log.isTraceEnabled()) {
                log.trace("ResourceHttpCacheConfigExtension accepts request [ {} ]", (Object)candidateResource);
            }
            return true;
        }
        return false;
    }

    @Override
    public CacheKey build(SlingHttpServletRequest slingHttpServletRequest, HttpCacheConfig cacheConfig) throws HttpCacheKeyCreationException {
        return new ResourceTypeCacheKey(slingHttpServletRequest, cacheConfig);
    }

    @Override
    public CacheKey build(String resourcePath, HttpCacheConfig cacheConfig) throws HttpCacheKeyCreationException {
        return new ResourceTypeCacheKey(resourcePath, cacheConfig);
    }

    @Override
    public boolean doesKeyMatchConfig(CacheKey key, HttpCacheConfig cacheConfig) throws HttpCacheKeyCreationException {
        if (!(key instanceof ResourceTypeCacheKey)) {
            return false;
        }
        return new ResourceTypeCacheKey(key.getUri(), cacheConfig).equals(key);
    }

    @Activate
    protected void activate(Map<String, Object> configs) {
        this.resourceTypePatterns = ParameterUtil.toPatterns(PropertiesUtil.toStringArray((Object)configs.get(PROP_RESOURCE_TYPES), (String[])new String[0]));
        this.pathPatterns = ParameterUtil.toPatterns(PropertiesUtil.toStringArray((Object)configs.get(PROP_PATHS), (String[])new String[0]));
        this.checkContentResourceType = PropertiesUtil.toBoolean((Object)configs.get(PROP_CHECK_CONTENT_RESOURCE_TYPE), (boolean)false);
        log.info("ResourceHttpCacheConfigExtension activated/modified.");
    }

    static class ResourceTypeCacheKey
    extends AbstractCacheKey
    implements CacheKey {
        public ResourceTypeCacheKey(SlingHttpServletRequest request, HttpCacheConfig cacheConfig) throws HttpCacheKeyCreationException {
            super(request, cacheConfig);
        }

        public ResourceTypeCacheKey(String uri, HttpCacheConfig cacheConfig) throws HttpCacheKeyCreationException {
            super(uri, cacheConfig);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            if (o == null) {
                return false;
            }
            ResourceTypeCacheKey that = (ResourceTypeCacheKey)o;
            return new EqualsBuilder().append((Object)this.getUri(), (Object)that.getUri()).append((Object)this.getAuthenticationRequirement(), (Object)that.getAuthenticationRequirement()).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.getUri()).append((Object)this.getAuthenticationRequirement()).toHashCode();
        }

        @Override
        public String toString() {
            return this.resourcePath + " [AUTH_REQ:" + this.getAuthenticationRequirement() + "]";
        }

        @Override
        public String getUri() {
            return this.resourcePath;
        }
    }
}

