/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.engine;

import com.adobe.acs.commons.httpcache.engine.HttpCacheServletResponseWrapper;
import com.adobe.acs.commons.httpcache.exception.HttpCacheDataStreamException;
import com.adobe.acs.commons.httpcache.store.TempSink;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CacheContent {
    private int status;
    private String charEncoding;
    private String contentType;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private InputStream dataInputStream;
    private TempSink tempSink;

    public CacheContent(String charEncoding, String contentType, Map<String, List<String>> headers, InputStream dataInputStream) {
        this(200, charEncoding, contentType, headers, dataInputStream);
    }

    public CacheContent(int status, String charEncoding, String contentType, Map<String, List<String>> headers, InputStream dataInputStream) {
        this.status = status;
        this.charEncoding = charEncoding;
        this.contentType = contentType;
        this.headers = headers;
        this.dataInputStream = dataInputStream;
    }

    public CacheContent() {
    }

    public CacheContent build(HttpCacheServletResponseWrapper responseWrapper) throws HttpCacheDataStreamException {
        this.status = responseWrapper.getStatus();
        this.charEncoding = responseWrapper.getCharacterEncoding();
        this.contentType = responseWrapper.getContentType();
        ArrayList headerNames = new ArrayList();
        headerNames.addAll(responseWrapper.getHeaderNames());
        for (String headerName : headerNames) {
            ArrayList values = new ArrayList();
            values.addAll(responseWrapper.getHeaders(headerName));
            this.headers.put(headerName, values);
        }
        this.tempSink = responseWrapper.getTempSink();
        this.dataInputStream = responseWrapper.getTempSink().createInputStream();
        return this;
    }

    public int getStatus() {
        return this.status;
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public InputStream getInputDataStream() {
        return this.dataInputStream;
    }

    public TempSink getTempSink() {
        return this.tempSink;
    }
}

