/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.invalidator.event;

import java.util.HashMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.event.jobs.JobManager;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - HTTP Cache - JCR node change invalidator.", description="Watches for the configured JCR paths and triggers cache invalidation job.", metatype=true, immediate=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(label="Event Topics", value={"org/apache/sling/api/resource/Resource/CHANGED", "org/apache/sling/api/resource/Resource/ADDED", "org/apache/sling/api/resource/Resource/REMOVED"}, description="This handler responds to resource modification event.", name="event.topics", propertyPrivate=true), @Property(label="JCR paths to watch for changes.", value={"(|(path=/content*)(path=/etc*))"}, description="Paths expressed in LDAP syntax. Example: (|(path=/content*)(path=/etc*)) - Watches for changes under /content or /etc. ", name="event.filter"), @Property(name="webconsole.configurationFactory.nameHint", value={"JCR paths to watch for changes: {event.filter}"}, propertyPrivate=true)})
@Service
public class JCRNodeChangeEventHandler
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(JCRNodeChangeEventHandler.class);
    @Reference
    private JobManager jobManager;

    public void handleEvent(Event event) {
        String path = (String)event.getProperty("path");
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("path", path);
        this.jobManager.addJob("com/adobe/acs/commons/httpcache/invalidator/job", payload);
        log.debug("New invalidation job created with the payload path. - {}", (Object)path);
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }
}

