/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.keys;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.day.cq.commons.PathInfo;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;

public abstract class AbstractCacheKey {
    protected String authenticationRequirement;
    protected String uri;
    protected String resourcePath;
    protected String hierarchyResourcePath;

    public AbstractCacheKey(SlingHttpServletRequest request, HttpCacheConfig cacheConfig) {
        this.authenticationRequirement = cacheConfig.getAuthenticationRequirement();
        this.uri = request.getRequestURI();
        this.resourcePath = this.unmangle(request.getResource().getPath());
        this.hierarchyResourcePath = this.makeHierarchyResourcePath(this.resourcePath);
    }

    public AbstractCacheKey(String uri, HttpCacheConfig cacheConfig) {
        this.authenticationRequirement = cacheConfig.getAuthenticationRequirement();
        this.uri = uri;
        this.resourcePath = this.unmangle(new PathInfo(uri).getResourcePath());
        this.hierarchyResourcePath = this.makeHierarchyResourcePath(this.resourcePath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getUri()).append((Object)this.getAuthenticationRequirement()).toHashCode();
    }

    public String getAuthenticationRequirement() {
        return this.authenticationRequirement;
    }

    public String getUri() {
        return this.uri;
    }

    public String getHierarchyResourcePath() {
        return this.hierarchyResourcePath;
    }

    public boolean isInvalidatedBy(CacheKey cacheKey) {
        return StringUtils.equals((CharSequence)this.hierarchyResourcePath, (CharSequence)cacheKey.getHierarchyResourcePath());
    }

    protected String makeHierarchyResourcePath(String resourcePath) {
        return StringUtils.substringBefore((String)resourcePath, (String)"/jcr:content");
    }

    private String unmangle(String str) {
        str = StringUtils.replace((String)str, (String)"jcr%3acontent", (String)"jcr:content");
        return StringUtils.replace((String)str, (String)"_jcr_content", (String)"jcr:content");
    }
}

