/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.store.mem.impl;

import com.adobe.acs.commons.httpcache.exception.HttpCacheDataStreamException;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;

class MemCachePersistenceObject {
    private int status;
    private String charEncoding;
    private String contentType;
    Multimap<String, String> headers;
    private byte[] bytes;
    AtomicInteger count = new AtomicInteger(0);

    MemCachePersistenceObject() {
    }

    public MemCachePersistenceObject buildForCaching(int status, String charEncoding, String contentType, Map<String, List<String>> headers, InputStream dataInputStream) throws HttpCacheDataStreamException {
        this.status = status;
        this.charEncoding = charEncoding;
        this.contentType = contentType;
        this.headers = HashMultimap.create();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            for (String value : entry.getValue()) {
                if ("Sling-Tracer-Protocol-Version".equals(entry.getKey()) || "Sling-Tracer-Request-Id".equals(entry.getKey())) continue;
                this.headers.put((Object)entry.getKey(), (Object)value);
            }
        }
        try {
            this.bytes = IOUtils.toByteArray((InputStream)dataInputStream);
        }
        catch (IOException e) {
            throw new HttpCacheDataStreamException("Unable to get byte array out of stream", e);
        }
        return this;
    }

    public int getStatus() {
        return this.status;
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, List<String>> getHeaders() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry entry : Multimaps.asMap(this.headers).entrySet()) {
            map.put((String)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        return map;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void incrementHitCount() {
        this.count.incrementAndGet();
    }

    public int getHitCount() {
        return this.count.get();
    }
}

