/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.images.transformers.impl;

import com.adobe.acs.commons.images.ImageTransformer;
import com.day.image.Layer;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Property(name="type", value={"adjust"})
@Service
public class AdjustImageTransformerImpl
implements ImageTransformer {
    private static final Logger log = LoggerFactory.getLogger(AdjustImageTransformerImpl.class);
    static final String TYPE = "adjust";
    private static final String KEY_BRIGHTNESS = "brightness";
    private static final String KEY_BRIGHTNESS_ALIAS = "b";
    private static final String KEY_CONTRAST = "contrast";
    private static final String KEY_CONTRAST_ALIAS = "c";

    @Override
    public final Layer transform(Layer layer, ValueMap properties) {
        if (properties == null || properties.isEmpty()) {
            log.warn("Transform [ {} ] requires parameters.", (Object)TYPE);
            return layer;
        }
        log.debug("Transforming with [ {} ]", (Object)TYPE);
        int brightness = (Integer)properties.get(KEY_BRIGHTNESS, properties.get(KEY_BRIGHTNESS_ALIAS, (Object)0));
        float contrast = ((Double)properties.get(KEY_CONTRAST, properties.get(KEY_CONTRAST_ALIAS, (Object)1.0))).floatValue();
        layer.adjust(brightness, contrast);
        return layer;
    }
}

