/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.images.transformers.impl;

import com.adobe.acs.commons.images.ImageTransformer;
import com.adobe.acs.commons.images.transformers.impl.composites.MultiplyBlendComposite;
import com.day.image.Layer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Properties(value={@Property(name="type", value={"multiply"})})
@Service
public class MultiplyBlendImageTransformerImpl
implements ImageTransformer {
    private static final Logger log = LoggerFactory.getLogger(MultiplyBlendImageTransformerImpl.class);
    static final String TYPE = "multiply";
    private static final String KEY_ALPHA = "alpha";
    private static final String KEY_ALPHA_ALIAS = "a";
    private static final String KEY_COLOR = "color";
    private static final String KEY_COLOR_ALIAS = "c";
    private static final String KEY_RED = "red";
    private static final String KEY_RED_ALIAS = "r";
    private static final String KEY_GREEN = "green";
    private static final String KEY_GREEN_ALIAS = "g";
    private static final String KEY_BLUE = "blue";
    private static final String KEY_BLUE_ALIAS = "b";
    private static final int DEFAULT_COLOR_VALUE = 255;

    @Override
    public final Layer transform(Layer layer, ValueMap properties) {
        if (properties == null || properties.isEmpty()) {
            log.warn("Transform [ {} ] requires parameters.", (Object)TYPE);
            return layer;
        }
        log.debug("Transforming with [ {} ]", (Object)TYPE);
        float alpha = this.normalizeAlpha(((Double)properties.get(KEY_ALPHA, properties.get(KEY_ALPHA_ALIAS, (Object)0.0))).floatValue());
        Color color = this.getColor(properties);
        Layer filter = new Layer(layer.getWidth(), layer.getHeight(), (Paint)color);
        BufferedImage image = this.merge(layer.getImage(), filter.getImage(), alpha);
        Layer result = new Layer(image);
        return result;
    }

    private BufferedImage merge(BufferedImage original, BufferedImage colorBlend, float alpha) {
        BufferedImage image = new BufferedImage(original.getWidth(), original.getHeight(), 2);
        Graphics2D graphics = image.createGraphics();
        graphics.setComposite(AlphaComposite.Clear);
        graphics.fillRect(0, 0, original.getWidth(), original.getHeight());
        graphics.setComposite(AlphaComposite.Src);
        graphics.drawImage((Image)original, 0, 0, null);
        graphics.setComposite(new MultiplyBlendComposite(alpha));
        graphics.drawImage((Image)colorBlend, 0, 0, null);
        graphics.dispose();
        return image;
    }

    private Color getColor(ValueMap properties) {
        Color color = this.getHexColor(properties);
        if (color == null) {
            color = this.getRGBColor(properties);
        }
        return color;
    }

    private Color getHexColor(ValueMap properties) {
        String hexcolor = (String)properties.get(KEY_COLOR, properties.get(KEY_COLOR_ALIAS, String.class));
        Color color = null;
        if (hexcolor != null) {
            try {
                color = Color.decode("0x" + hexcolor);
            }
            catch (NumberFormatException ex) {
                log.warn("Invalid hex color specified: {}", (Object)hexcolor);
            }
        }
        return color;
    }

    private Color getRGBColor(ValueMap properties) {
        int red = this.normalizeRGB((Integer)properties.get(KEY_RED, properties.get(KEY_RED_ALIAS, (Object)255)));
        int green = this.normalizeRGB((Integer)properties.get(KEY_GREEN, properties.get(KEY_GREEN_ALIAS, (Object)255)));
        int blue = this.normalizeRGB((Integer)properties.get(KEY_BLUE, properties.get(KEY_BLUE_ALIAS, (Object)255)));
        Color color = new Color(red, green, blue);
        return color;
    }

    private float normalizeAlpha(float alpha) {
        if (alpha > 1.0f) {
            alpha = 1.0f;
        } else if (alpha < 0.0f) {
            alpha = 0.0f;
        }
        return alpha;
    }

    private int normalizeRGB(int rgbValue) {
        if (rgbValue > 255) {
            rgbValue = 255;
        } else if (rgbValue < 0) {
            rgbValue = 0;
        }
        return rgbValue;
    }
}

