/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ModifiableValueMapDecorator;
import org.apache.sling.api.wrappers.ValueMapDecorator;

public class AbstractResourceImpl
extends AbstractResource {
    List<Resource> children = new ArrayList<Resource>();
    ResourceMetadata meta;
    ResourceResolver rr;
    Resource parent;
    String path;
    String type;
    String superType;

    public AbstractResourceImpl(String path, String resourceType, String resourceSuperType, ResourceMetadata metadata) {
        this.path = path;
        this.type = resourceType;
        this.superType = resourceSuperType;
        this.meta = metadata;
    }

    public <T> T adaptTo(Class<T> clazz) {
        if (clazz.equals(ModifiableValueMap.class)) {
            return (T)new ModifiableValueMapDecorator((Map)this.getValueMap());
        }
        return null;
    }

    public void setResourceResolver(ResourceResolver rr) {
        this.rr = rr;
    }

    public void addChild(Resource res) {
        this.children.add(res);
        if (res instanceof AbstractResourceImpl) {
            AbstractResourceImpl child = (AbstractResourceImpl)res;
            child.parent = this;
            if (!child.path.startsWith("/")) {
                child.path = this.path + "/" + child.path;
            }
            ((AbstractResourceImpl)res).setResourceResolver(this.rr);
        }
    }

    public String getName() {
        return this.path.substring(this.path.lastIndexOf(47) + 1);
    }

    public Resource getParent() {
        return this.parent;
    }

    public Resource getChild(String relPath) {
        return this.children.stream().filter(c -> c.getName().equals(relPath)).findFirst().orElse(null);
    }

    public Iterable<Resource> getChildren() {
        return this.children;
    }

    public Iterator<Resource> listChildren() {
        return this.children.iterator();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public String getPath() {
        return this.path;
    }

    public String getResourceType() {
        return this.type;
    }

    public String getResourceSuperType() {
        return this.superType;
    }

    public ResourceMetadata getResourceMetadata() {
        return this.meta;
    }

    public ValueMap getValueMap() {
        return new ValueMapDecorator((Map)this.meta);
    }

    public ResourceResolver getResourceResolver() {
        return this.rr;
    }
}

