/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.functions.CheckedConsumer;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.PathfieldComponent;
import com.adobe.acs.commons.mcp.form.RadioComponent;
import com.adobe.acs.commons.mcp.model.GenericReport;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.mime.MimeTypeService;

public abstract class AssetIngestor
extends ProcessDefinition {
    private final MimeTypeService mimetypeService;
    @FormField(name="Target JCR Folder", description="Base folder for ingestion", hint="/content/dam", component=PathfieldComponent.FolderSelectComponent.class, required=true, options={"default=/content/dam", "base=/content/dam"})
    String jcrBasePath;
    @FormField(name="Ignore folders", description="List of folder names to be ignored", hint="tmp,.DS_STORE", options={"default=tmp,ds_store,.ds_store,.thumbs,.appledouble"})
    String ignoreFolders;
    List<String> ignoreFolderList;
    @FormField(name="Ignore files", description="List of file names to ignore", hint="full file names, comma separated", options={"default=ds_store,.ds_store"})
    String ignoreFiles;
    List<String> ignoreFileList;
    @FormField(name="Ignore extensions", description="List of file extensions to ignore", hint="mp4,txt, etc.", options={"default=txt,html,css,js,thm,exe,db"})
    String ignoreExtensions;
    List<String> ignoreExtensionList;
    @FormField(name="Existing action", description="What to do if an asset exists", component=RadioComponent.EnumerationSelector.class, options={"default=skip", "vertical"})
    AssetAction existingAssetAction;
    @FormField(name="Minimum size", description="Min size to import (in bytes), 0=none", hint="1024...", options={"default=1024"})
    long minimumSize;
    @FormField(name="Maximum size", description="Max size to import (in bytes), 0=none", hint="1gb = 1073741824", options={"default=1073741824"})
    long maximumSize;
    protected static final String DEFAULT_FOLDER_TYPE = "sling:Folder";
    protected static final String CHANGED_BY_WORKFLOW = "changedByWorkflowProcess";
    AtomicInteger folderCount = new AtomicInteger();
    AtomicInteger assetCount = new AtomicInteger();
    AtomicInteger filesSkipped = new AtomicInteger();
    AtomicLong totalImportedData = new AtomicLong();
    GenericReport report = new GenericReport();

    public AssetIngestor(MimeTypeService mimeTypeService) {
        this.mimetypeService = mimeTypeService;
    }

    @Override
    public void init() throws RepositoryException {
        if (this.ignoreFolders == null) {
            this.ignoreFolders = "";
        }
        this.ignoreFolderList = Arrays.asList(this.ignoreFolders.trim().toLowerCase().split(","));
        if (this.ignoreFiles == null) {
            this.ignoreFiles = "";
        }
        this.ignoreFileList = Arrays.asList(this.ignoreFiles.trim().toLowerCase().split(","));
        if (this.ignoreExtensions == null) {
            this.ignoreExtensions = "";
        }
        this.ignoreExtensionList = Arrays.asList(this.ignoreExtensions.trim().toLowerCase().split(","));
    }

    private void createAsset(Source source, String assetPath, ResourceResolver r, boolean versioning) throws Exception {
        ((Session)r.adaptTo(Session.class)).getWorkspace().getObservationManager().setUserData(CHANGED_BY_WORKFLOW);
        AssetManager assetManager = (AssetManager)r.adaptTo(AssetManager.class);
        String type = this.mimetypeService.getMimeType(source.getName());
        if (versioning) {
            Asset asset = (Asset)r.getResource(assetPath).adaptTo(Asset.class);
            assetManager.createRevision(asset, "initial version of asset", asset.getName());
            r.commit();
            r.refresh();
        }
        assetManager.createAsset(assetPath, source.getStream(), type, false);
        r.commit();
        r.refresh();
        this.totalImportedData.accumulateAndGet(source.getLength(), (p, x) -> p + x);
        this.assetCount.incrementAndGet();
    }

    protected void handleExistingAsset(Source source, String assetPath, ResourceResolver r) throws Exception {
        switch (this.existingAssetAction) {
            case skip: {
                if (r.getResource(assetPath) == null) {
                    this.createAsset(source, assetPath, r, false);
                    break;
                }
                this.filesSkipped.incrementAndGet();
                break;
            }
            case replace: {
                this.createAsset(source, assetPath, r, false);
                break;
            }
            default: {
                this.versionExistingAsset(source, assetPath, r);
            }
        }
    }

    protected boolean createFolderNode(HierarchialElement el, ResourceResolver r) throws RepositoryException, PersistenceException {
        if (el == null || !el.isFolder()) {
            return false;
        }
        String folderPath = el.getNodePath();
        String name = el.getName();
        Session s = (Session)r.adaptTo(Session.class);
        if (s.nodeExists(folderPath)) {
            Node folderNode = s.getNode(folderPath);
            if (folderPath.equals(this.jcrBasePath) || folderNode.hasProperty("jcr:title") && folderNode.getProperty("jcr:title").getString().equals(name)) {
                return false;
            }
            folderNode.setProperty("jcr:title", name);
            r.commit();
            r.refresh();
            return true;
        }
        HierarchialElement parent = el.getParent();
        String parentPath = parent == null ? this.jcrBasePath : parent.getNodePath();
        if (!this.jcrBasePath.equals(parentPath)) {
            this.createFolderNode(parent, r);
        }
        Node child = s.getNode(parentPath).addNode(el.getNodeName(), DEFAULT_FOLDER_TYPE);
        this.folderCount.incrementAndGet();
        if (!folderPath.equals(this.jcrBasePath)) {
            child.setProperty("jcr:title", name);
        }
        r.commit();
        r.refresh();
        return true;
    }

    private void versionExistingAsset(Source source, String assetPath, ResourceResolver r) throws Exception {
        this.createAsset(source, assetPath, r, r.getResource(assetPath) != null);
    }

    protected CheckedConsumer<ResourceResolver> importAsset(Source source, ActionManager actionManager) {
        return r -> {
            String path = source.getElement().getNodePath();
            this.createFolderNode(source.getElement().getParent(), (ResourceResolver)r);
            actionManager.setCurrentItem(source.getElement().getItemName());
            this.handleExistingAsset(source, path, (ResourceResolver)r);
        };
    }

    protected boolean canImportFile(Source source) {
        int extPos;
        String ext;
        String name = source.getName().toLowerCase();
        if (this.minimumSize > 0L && source.getLength() < this.minimumSize) {
            return false;
        }
        if (this.maximumSize > 0L && source.getLength() > this.maximumSize) {
            return false;
        }
        if (name.startsWith(".") || this.ignoreFileList.contains(name)) {
            return false;
        }
        return !name.contains(".") || !this.ignoreExtensionList.contains(ext = name.substring((extPos = name.lastIndexOf(46)) + 1));
    }

    protected boolean canImportFolder(HierarchialElement element) {
        String name = element.getName();
        if (this.ignoreFolderList.contains(name.toLowerCase())) {
            return false;
        }
        HierarchialElement parent = element.getParent();
        if (parent == null) {
            return true;
        }
        return this.canImportFolder(parent);
    }

    protected boolean canImportContainingFolder(HierarchialElement element) {
        HierarchialElement parent = element.getParent();
        if (parent == null) {
            return true;
        }
        return this.canImportFolder(parent);
    }

    @Override
    public void storeReport(ProcessInstance instance, ResourceResolver rr) throws RepositoryException, PersistenceException {
        EnumMap<ReportColumns, Number> values = new EnumMap<ReportColumns, Number>(ReportColumns.class);
        ArrayList rows = new ArrayList();
        rows.add(values);
        values.put(ReportColumns.folder_count, this.folderCount);
        values.put(ReportColumns.asset_count, this.assetCount);
        values.put(ReportColumns.files_skipped, this.filesSkipped);
        values.put(ReportColumns.data_imported, this.totalImportedData);
        this.report.setRows(rows, ReportColumns.class);
        this.report.persist(rr, instance.getPath() + "/jcr:content/report");
    }

    protected static interface HierarchialElement {
        public boolean isFile();

        public boolean isFolder();

        public HierarchialElement getParent();

        public String getName();

        public String getItemName();

        public Source getSource();

        public String getJcrBasePath();

        default public String getNodePath() {
            HierarchialElement parent = this.getParent();
            return (parent == null ? this.getJcrBasePath() : parent.getNodePath()) + "/" + this.getNodeName();
        }

        default public String getNodeName() {
            String name = this.getName();
            if (this.isFile() && name.contains(".")) {
                String baseName = StringUtils.substringBeforeLast((String)name, (String)".");
                String extension = StringUtils.substringAfterLast((String)name, (String)".");
                return JcrUtil.createValidName((String)baseName) + "." + JcrUtil.createValidName((String)extension);
            }
            return JcrUtil.createValidName((String)name);
        }
    }

    protected static interface Source {
        public String getName();

        public InputStream getStream() throws IOException;

        public long getLength();

        public HierarchialElement getElement();
    }

    static enum ReportColumns {
        folder_count,
        asset_count,
        files_skipped,
        data_imported;

    }

    public static enum AssetAction {
        skip,
        version,
        replace;

    }
}

