/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.CheckboxComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.PathfieldComponent;
import com.adobe.acs.commons.mcp.model.GenericReport;
import com.adobe.acs.commons.util.visitors.TreeFilteringResourceVisitor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.html.HtmlParser;
import org.apache.tika.sax.Link;
import org.apache.tika.sax.LinkContentHandler;
import org.xml.sax.ContentHandler;

public class BrokenLinksReport
extends ProcessDefinition
implements Serializable {
    @FormField(name="Source page", description="Select page/site to be analyzed", hint="/content/my-site", component=PathfieldComponent.PageSelectComponent.class, options={"base=/content"})
    private String sourcePath;
    @FormField(name="Property Regex", description="Regular expression to detect properties containing references to Sling resources", required=false, options={"default=^/(etc|content)/.+"})
    private String propertyRegex;
    @FormField(name="Exclude Properties", description="Comma-separated list of properties to ignore", hint="cq:template,cq:allowedTemplates,....", required=false, options={"default=cq:allowedTemplates"})
    private String excludeProperties;
    @FormField(name="Deep check in html", description="If checked, links will be extracted from html properties", component=CheckboxComponent.class, options={"checked"})
    private boolean deepCheck = false;
    @FormField(name="Properties containing html", description="Comma-separate list of properties containing html to extract links", required=false, options={"default=text"})
    private String htmlFields;
    private transient Set<String> excludeList;
    private transient Set<String> deepCheckList;
    private transient Pattern regex;
    private final transient GenericReport report = new GenericReport();
    private final transient Map<String, EnumMap<Report, Object>> reportData = new ConcurrentHashMap<String, EnumMap<Report, Object>>();

    @Override
    public void init() throws RepositoryException {
        this.excludeList = Arrays.stream(this.excludeProperties.split(",")).map(String::trim).collect(Collectors.toSet());
        this.deepCheckList = this.deepCheck ? Arrays.stream(this.htmlFields.split(",")).map(String::trim).collect(Collectors.toSet()) : new HashSet<String>();
        this.regex = Pattern.compile(this.propertyRegex);
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException, RepositoryException {
        this.report.setName(instance.getName());
        instance.defineAction("Collect Broken References", rr, this::buildReport);
        instance.getInfo().setDescription(this.sourcePath);
    }

    @Override
    public void storeReport(ProcessInstance instance, ResourceResolver rr) throws RepositoryException, PersistenceException {
        GenericReport genericReport = new GenericReport();
        genericReport.setRows(this.reportData, "Source", Report.class);
        genericReport.persist(rr, instance.getPath() + "/jcr:content/report");
    }

    public void buildReport(ActionManager manager) {
        TreeFilteringResourceVisitor visitor = new TreeFilteringResourceVisitor();
        visitor.setBreadthFirstMode();
        visitor.setTraversalFilter(null);
        visitor.setResourceVisitor((resource, depth) -> manager.deferredWithResolver(rr -> {
            Map<String, List<String>> brokenRefs = BrokenLinksReport.collectBrokenReferences(resource, this.regex, this.excludeList, this.deepCheckList);
            for (Map.Entry<String, List<String>> ref : brokenRefs.entrySet()) {
                String propertyPath = ref.getKey();
                List<String> refs = ref.getValue();
                this.reportData.put(propertyPath, new EnumMap(Report.class));
                this.reportData.get(propertyPath).put(Report.reference, (Object)refs.stream().collect(Collectors.joining(",")));
            }
        }));
        manager.deferredWithResolver(rr -> visitor.accept(rr.getResource(this.sourcePath)));
    }

    static Stream<String> collectPaths(Map.Entry<String, Object> property, Set<String> htmlFields) {
        Object p = property.getValue();
        Stream<String> stream = p.getClass() == String[].class ? Arrays.stream((String[])p) : (p.getClass() == String.class ? Stream.of((String)p) : Stream.empty());
        if (htmlFields.contains(property.getKey())) {
            stream = stream.flatMap(val -> {
                try {
                    LinkContentHandler linkHandler = new LinkContentHandler();
                    HtmlParser parser = new HtmlParser();
                    parser.parse((InputStream)new ByteArrayInputStream(val.getBytes("utf-8")), (ContentHandler)linkHandler, new Metadata(), new ParseContext());
                    return linkHandler.getLinks().stream().map(Link::getUri);
                }
                catch (Exception e) {
                    return Stream.empty();
                }
            });
        }
        return stream;
    }

    static Map<String, List<String>> collectBrokenReferences(Resource resource, Pattern regex, Set<String> skipList, Set<String> htmlFields) {
        return resource.getValueMap().entrySet().stream().filter(entry -> !skipList.contains(entry.getKey())).collect(Collectors.toMap(entry -> resource.getPath() + "/" + (String)entry.getKey(), entry -> {
            List brokenPaths = BrokenLinksReport.collectPaths(entry, htmlFields).filter(href -> regex.matcher((CharSequence)href).matches()).filter(path -> ResourceUtil.isNonExistingResource((Resource)resource.getResourceResolver().resolve(path))).collect(Collectors.toList());
            return brokenPaths;
        })).entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (List)e.getValue()));
    }

    Map<String, EnumMap<Report, Object>> getReportData() {
        return this.reportData;
    }

    static enum Report {
        reference;

    }
}

