/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.Failure;
import com.adobe.acs.commons.fam.actions.ActionBatch;
import com.adobe.acs.commons.fam.actions.Actions;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.PathfieldComponent;
import com.adobe.acs.commons.mcp.form.RadioComponent;
import com.adobe.acs.commons.util.visitors.SimpleFilteringResourceVisitor;
import com.adobe.acs.commons.util.visitors.TreeFilteringResourceVisitor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class FolderRelocator
extends ProcessDefinition
implements Serializable {
    private static final long serialVersionUID = 7526472295622776160L;
    private Map<String, String> sourceToDestination;
    @FormField(name="Source folder(s)", description="One or more source folders must be provided.  Multiple folders implies a move operation.", hint="/content/dam/someFolder", component=PathfieldComponent.FolderSelectComponent.class, options={"base=/content/dam", "multiple"})
    private String[] sourcePaths;
    @FormField(name="Destination folder", description="Destination parent for move, or destination parent folder plus new name for rename", hint="Move: /content/dam/moveToFolder | Rename: /content/dam/moveToFolder/newName", component=PathfieldComponent.FolderSelectComponent.class, options={"base=/content/dam"})
    private String destinationPath;
    @FormField(name="Mode", description="Move relocates one or more folders.  Rename relocates and takes the last part of the path as the new name for one folder.", required=false, component=RadioComponent.EnumerationSelector.class, options={"horizontal", "default=MOVE"})
    private Mode mode;
    private final transient String[] requiredFolderPrivilegeNames = new String[]{"{http://www.jcp.org/jcr/1.0}read", "{http://www.jcp.org/jcr/1.0}write", "{http://www.jcp.org/jcr/1.0}removeChildNodes", "{http://www.jcp.org/jcr/1.0}removeNode"};
    private final transient String[] requiredNodePrivilegeNames = new String[]{"{http://www.jcp.org/jcr/1.0}all"};
    private transient Privilege[] requiredFolderPrivileges;
    private transient Privilege[] requiredNodePrivileges;
    private int batchSize = 5;

    public FolderRelocator() {
    }

    public FolderRelocator(String[] sourcePaths, String destinationPath) {
        this.init(sourcePaths, destinationPath);
    }

    public FolderRelocator(String sourcePath, String destinationPath, Mode processMode) {
        this.init(sourcePath, destinationPath, processMode);
    }

    @Override
    public void init() throws RepositoryException {
        if (this.sourcePaths != null && this.sourcePaths.length == 1) {
            this.init(this.sourcePaths[0], this.destinationPath, this.mode);
        } else {
            this.init(this.sourcePaths, this.destinationPath);
        }
    }

    private void init(String[] sourcePaths, String destinationPath) {
        this.sourceToDestination = new HashMap<String, String>();
        this.mode = Mode.MOVE;
        for (String sourcePath : sourcePaths) {
            String nodeName = sourcePath.substring(sourcePath.lastIndexOf(47));
            String destination = destinationPath + nodeName;
            this.sourceToDestination.put(sourcePath, destination);
        }
    }

    private void init(String sourcePath, String destinationPath, Mode processMode) {
        this.sourceToDestination = new HashMap<String, String>();
        this.mode = processMode;
        String destination = destinationPath;
        if (this.mode == Mode.MOVE) {
            String nodeName = sourcePath.substring(sourcePath.lastIndexOf(47));
            destination = destination + nodeName;
        }
        this.sourceToDestination.put(sourcePath, destination);
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException, RepositoryException {
        this.validateInputs(rr);
        Session ses = (Session)rr.adaptTo(Session.class);
        this.requiredFolderPrivileges = this.getPrivilegesFromNames(ses, this.requiredFolderPrivilegeNames);
        this.requiredNodePrivileges = this.getPrivilegesFromNames(ses, this.requiredNodePrivilegeNames);
        instance.defineCriticalAction("Validate ACLs", rr, this::validateAllAcls);
        instance.defineCriticalAction("Build target folders", rr, this::buildTargetFolders).onFailure(this::abortStep2);
        instance.defineCriticalAction("Move nodes", rr, this::moveNodes);
        instance.defineCriticalAction("Remove old folders", rr, this::removeSourceFolders);
        if (this.sourcePaths.length > 1) {
            instance.getInfo().setDescription("Move " + this.sourcePaths.length + " folders to " + this.destinationPath);
        } else {
            String verb = StringUtils.capitalize((String)this.mode.name().toLowerCase());
            instance.getInfo().setDescription(verb + " " + this.sourcePaths[0] + " to " + this.destinationPath);
        }
    }

    private void validateInputs(ResourceResolver res) throws RepositoryException {
        Optional<RepositoryException> error = this.sourceToDestination.entrySet().stream().map(pair -> {
            String entrySourcePath = (String)pair.getKey();
            String entryDestinationPath = (String)pair.getValue();
            if (entrySourcePath == null) {
                return new RepositoryException("Source path should not be null");
            }
            if (entryDestinationPath == null) {
                return new RepositoryException("Destination path should not be null");
            }
            if (entryDestinationPath.contains(entrySourcePath + "/")) {
                return new RepositoryException("Destination must be outside of source folder");
            }
            if (!this.resourceExists(res, entrySourcePath)) {
                if (!entrySourcePath.startsWith("/")) {
                    return new RepositoryException("Paths are not valid unless they start with a forward slash, you provided: " + entrySourcePath);
                }
                return new RepositoryException("Unable to find source " + entrySourcePath);
            }
            if (!this.resourceExists(res, entryDestinationPath.substring(0, entryDestinationPath.lastIndexOf(47)))) {
                if (!entryDestinationPath.startsWith("/")) {
                    return new RepositoryException("Paths are not valid unless they start with a forward slash, you provided: " + entryDestinationPath);
                }
                return new RepositoryException("Unable to find destination " + entryDestinationPath);
            }
            return null;
        }).filter(Objects::nonNull).findFirst();
        if (error.isPresent()) {
            Logger.getLogger(FolderRelocator.class.getName()).log(Level.SEVERE, "Validation error prior to starting move operations: {0}", error.get().getMessage());
            throw error.get();
        }
    }

    private boolean resourceExists(ResourceResolver rr, String path) {
        Resource res = rr.getResource(path);
        return res != null && !"sling:nonexisting".equals(res.getResourceType());
    }

    private void validateAllAcls(ActionManager step1) {
        TreeFilteringResourceVisitor folderVisitor = new TreeFilteringResourceVisitor();
        folderVisitor.setBreadthFirstMode();
        folderVisitor.setResourceVisitor((resource, level) -> step1.deferredWithResolver(rr -> this.checkNodeAcls((ResourceResolver)rr, resource.getPath(), this.requiredFolderPrivileges)));
        folderVisitor.setLeafVisitor((resource, level) -> step1.deferredWithResolver(rr -> this.checkNodeAcls((ResourceResolver)rr, resource.getPath(), this.requiredNodePrivileges)));
        this.sourceToDestination.keySet().forEach(sourcePath -> this.beginStep(step1, (String)sourcePath, folderVisitor));
    }

    private Privilege[] getPrivilegesFromNames(Session session, String[] names) throws RepositoryException {
        AccessControlManager acm = session.getAccessControlManager();
        Privilege[] prvlgs = new Privilege[names.length];
        for (int i = 0; i < names.length; ++i) {
            prvlgs[i] = acm.privilegeFromName(names[i]);
        }
        return prvlgs;
    }

    private void checkNodeAcls(ResourceResolver res, String path, Privilege[] prvlgs) throws RepositoryException {
        Actions.setCurrentItem(path);
        Session session = (Session)res.adaptTo(Session.class);
        if (!session.getAccessControlManager().hasPrivileges(path, prvlgs)) {
            throw new RepositoryException("Insufficient permissions to permit move operation");
        }
    }

    private void buildTargetFolders(ActionManager step2) {
        TreeFilteringResourceVisitor folderVisitor = new TreeFilteringResourceVisitor();
        folderVisitor.setBreadthFirstMode();
        folderVisitor.setResourceVisitor((res, level) -> {
            String path = res.getPath();
            step2.deferredWithResolver(Actions.retry(5, 100L, rr -> this.buildDestinationFolder((ResourceResolver)rr, path)));
        });
        this.sourceToDestination.keySet().forEach(sourcePath -> this.beginStep(step2, (String)sourcePath, folderVisitor));
    }

    private void abortStep2(List<Failure> errors, ResourceResolver rr) {
        Logger.getLogger(FolderRelocator.class.getName()).log(Level.SEVERE, "{0} issues enountered trying to create destination folder structure; aborting process.", errors.size());
        this.sourceToDestination.keySet().forEach(sourcePath -> {
            try {
                rr.delete(rr.getResource(this.convertSourceToDestination((String)sourcePath)));
            }
            catch (RepositoryException | PersistenceException ex) {
                rr.refresh();
                Logger.getLogger(FolderRelocator.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
    }

    private void buildDestinationFolder(ResourceResolver rr, String sourceFolder) throws PersistenceException, RepositoryException, InterruptedException {
        String sourceJcrContent;
        Session session = (Session)rr.adaptTo(Session.class);
        session.getWorkspace().getObservationManager().setUserData("changedByWorkflowProcess");
        Resource source = rr.getResource(sourceFolder);
        String targetPath = this.convertSourceToDestination(sourceFolder);
        if (!this.resourceExists(rr, targetPath)) {
            Actions.setCurrentItem(sourceFolder + "->" + targetPath);
            String targetParentPath = targetPath.substring(0, targetPath.lastIndexOf(47));
            String targetName = targetPath.substring(targetPath.lastIndexOf(47) + 1);
            this.waitUntilResourceFound(rr, targetParentPath);
            Resource destParent = rr.getResource(targetParentPath);
            Logger.getLogger(FolderRelocator.class.getName()).log(Level.INFO, "Creating target for {0}", sourceFolder);
            rr.create(destParent, targetName, (Map)source.getValueMap());
            rr.commit();
            rr.refresh();
        }
        if (this.resourceExists(rr, sourceJcrContent = sourceFolder + "/jcr:content")) {
            Actions.getCurrentActionManager().deferredWithResolver(Actions.retry(5, 50L, rrr -> {
                if (!this.resourceExists((ResourceResolver)rrr, targetPath + "/jcr:content")) {
                    this.waitUntilResourceFound((ResourceResolver)rrr, targetPath);
                    rrr.copy(sourceJcrContent, targetPath);
                    rrr.commit();
                    rrr.refresh();
                }
            }));
        }
    }

    private void waitUntilResourceFound(ResourceResolver rr, String path) throws InterruptedException, RepositoryException {
        for (int i = 0; i < 10; ++i) {
            if (this.resourceExists(rr, path)) {
                return;
            }
            Thread.sleep(100L);
            rr.refresh();
        }
        throw new RepositoryException("Resource not found: " + path);
    }

    private String convertSourceToDestination(String path) throws RepositoryException {
        return this.sourceToDestination.entrySet().stream().filter(entry -> path.startsWith((String)entry.getKey())).findFirst().map(entry -> path.replaceAll(Pattern.quote((String)entry.getKey()), (String)entry.getValue())).orElseThrow(() -> new RepositoryException("Cannot determine destination for " + path));
    }

    private void moveNodes(ActionManager step3) {
        ActionBatch batch = new ActionBatch(step3, this.batchSize);
        batch.setRetryCount(10);
        TreeFilteringResourceVisitor folderVisitor = new TreeFilteringResourceVisitor();
        folderVisitor.setBreadthFirstMode();
        folderVisitor.setLeafVisitor((res, level) -> {
            String path = res.getPath();
            if (!path.endsWith("jcr:content")) {
                batch.add(rr -> this.moveItem((ResourceResolver)rr, path));
            }
        });
        this.sourceToDestination.keySet().forEach(sourcePath -> this.beginStep(step3, (String)sourcePath, folderVisitor));
        batch.commitBatch();
    }

    private void moveItem(ResourceResolver rr, String path) throws RepositoryException {
        Logger.getLogger(FolderRelocator.class.getName()).log(Level.INFO, "Moving {0}", path);
        Actions.setCurrentItem(path);
        Session session = (Session)rr.adaptTo(Session.class);
        session.getWorkspace().getObservationManager().setUserData("changedByWorkflowProcess");
        session.move(path, this.convertSourceToDestination(path));
    }

    private void removeSourceFolders(ActionManager step4) {
        this.sourceToDestination.keySet().forEach(sourcePath -> step4.deferredWithResolver(Actions.retry(5, 100L, rr -> this.deleteResource((ResourceResolver)rr, (String)sourcePath))));
    }

    private void deleteResource(ResourceResolver rr, String path) throws PersistenceException {
        Actions.setCurrentItem(path);
        rr.delete(rr.getResource(path));
    }

    private void beginStep(ActionManager step, String startingNode, SimpleFilteringResourceVisitor visitor) {
        try {
            step.withResolver(rr -> visitor.accept(rr.getResource(startingNode)));
        }
        catch (Exception ex) {
            Logger.getLogger(FolderRelocator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void storeReport(ProcessInstance instance, ResourceResolver rr) {
    }

    public static enum Mode {
        RENAME,
        MOVE;

    }
}

