/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.actions.Actions;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.PasswordComponent;
import com.adobe.acs.commons.mcp.impl.processes.AssetIngestor;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.day.cq.commons.jcr.JcrUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.mime.MimeTypeService;

public class S3AssetIngestor
extends AssetIngestor {
    @FormField(name="Bucket", description="S3 Bucket Name")
    String bucket;
    @FormField(name="Access Key", description="S3 Access Key")
    String accessKey;
    @FormField(name="Secret Key", description="S3 Secret Key", component=PasswordComponent.class)
    String secretKey;
    @FormField(name="S3 Base Path", description="S3 Base Path (Prefix)", required=false)
    String s3BasePath;
    @FormField(name="Endpoint URL", description="Endpoint URL, leave blank for default. Used primarily for S3-compatible object-storage solutions.", required=false)
    String endpointUrl;
    transient AmazonS3 s3Client;
    transient String baseItemName;

    public S3AssetIngestor(MimeTypeService mimeTypeService) {
        super(mimeTypeService);
    }

    @Override
    public void init() throws RepositoryException {
        super.init();
        this.baseItemName = StringUtils.isNotBlank((CharSequence)this.s3BasePath) ? this.bucket + ":" + this.s3BasePath : this.bucket;
        if (StringUtils.isNotBlank((CharSequence)this.endpointUrl)) {
            this.baseItemName = this.endpointUrl + "/" + this.baseItemName;
        }
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException, RepositoryException {
        if (StringUtils.isNotBlank((CharSequence)this.s3BasePath) && !this.s3BasePath.endsWith("/")) {
            this.s3BasePath = this.s3BasePath + "/";
        }
        instance.getInfo().setDescription(this.baseItemName + "->" + this.jcrBasePath);
        instance.defineCriticalAction("Create Folders", rr, this::createFolders);
        instance.defineCriticalAction("Import Assets", rr, this::importAssets);
        this.s3Client = new AmazonS3Client((AWSCredentials)new BasicAWSCredentials(this.accessKey, this.secretKey));
        if (StringUtils.isNotBlank((CharSequence)this.endpointUrl)) {
            this.s3Client.setEndpoint(this.endpointUrl);
        }
    }

    void createFolders(ActionManager manager) {
        manager.deferredWithResolver(r -> {
            JcrUtil.createPath((String)this.jcrBasePath, (String)"sling:Folder", (String)"sling:Folder", (Session)((Session)r.adaptTo(Session.class)), (boolean)true);
            manager.setCurrentItem(this.baseItemName);
            ObjectListing listing = this.s3Client.listObjects(this.bucket, this.s3BasePath);
            this.createFolders(manager, listing);
        });
    }

    private void createFolders(ActionManager manager, ObjectListing listing) {
        listing.getObjectSummaries().stream().filter(sum -> !sum.getKey().equals(this.s3BasePath)).map(x$0 -> new S3HierarchialElement((S3ObjectSummary)x$0)).filter(S3HierarchialElement::isFolder).filter(this::canImportFolder).forEach(el -> manager.deferredWithResolver(Actions.retry(10, 100L, rr -> {
            manager.setCurrentItem(el.getItemName());
            this.createFolderNode((AssetIngestor.HierarchialElement)el, (ResourceResolver)rr);
        })));
        if (listing.isTruncated()) {
            this.createFolders(manager, this.s3Client.listNextBatchOfObjects(listing));
        }
    }

    void importAssets(ActionManager manager) {
        manager.deferredWithResolver(rr -> {
            JcrUtil.createPath((String)this.jcrBasePath, (String)"sling:Folder", (String)"sling:Folder", (Session)((Session)rr.adaptTo(Session.class)), (boolean)true);
            manager.setCurrentItem(this.baseItemName);
            ObjectListing listing = this.s3Client.listObjects(this.bucket, this.s3BasePath);
            this.importAssets(manager, listing);
        });
    }

    private void importAssets(ActionManager manager, ObjectListing listing) {
        listing.getObjectSummaries().stream().map(x$0 -> new S3HierarchialElement((S3ObjectSummary)x$0)).filter(S3HierarchialElement::isFile).filter(this::canImportContainingFolder).map(S3HierarchialElement::getSource).forEach(ss -> {
            if (this.canImportFile((AssetIngestor.Source)ss)) {
                manager.deferredWithResolver(Actions.retry(5, 25L, this.importAsset((AssetIngestor.Source)ss, manager)));
            } else {
                this.filesSkipped.incrementAndGet();
            }
        });
        if (listing.isTruncated()) {
            this.createFolders(manager, this.s3Client.listNextBatchOfObjects(listing));
        }
    }

    class S3HierarchialElement
    implements AssetIngestor.HierarchialElement {
        private final S3ObjectSummary original;
        private final String negativePath;
        final String effectiveKey;

        S3HierarchialElement(S3ObjectSummary original) {
            this(original, null);
        }

        private S3HierarchialElement(S3ObjectSummary original, String negativePath) {
            this.original = original;
            this.negativePath = negativePath != null ? negativePath : "";
            this.effectiveKey = original.getKey().substring(0, original.getKey().length() - this.negativePath.length());
        }

        @Override
        public boolean isFile() {
            return !this.isFolder();
        }

        @Override
        public boolean isFolder() {
            return this.effectiveKey.endsWith("/");
        }

        @Override
        public AssetIngestor.HierarchialElement getParent() {
            if (this.isFolder()) {
                String newNegativePath = this.getName() + "/" + this.negativePath;
                String newEffectiveKey = this.original.getKey().substring(0, this.original.getKey().length() - newNegativePath.length());
                if (newNegativePath.equals(this.original.getKey()) || newEffectiveKey.equals(S3AssetIngestor.this.s3BasePath)) {
                    return null;
                }
                return new S3HierarchialElement(this.original, newNegativePath);
            }
            String newNegativePath = this.getName();
            String newEffectiveKey = this.original.getKey().substring(0, this.original.getKey().length() - newNegativePath.length());
            if (newNegativePath.equals(this.original.getKey()) || newEffectiveKey.equals(S3AssetIngestor.this.s3BasePath)) {
                return null;
            }
            return new S3HierarchialElement(this.original, newNegativePath);
        }

        @Override
        public String getName() {
            String keyWithoutTrailingSlash = this.isFolder() ? this.effectiveKey.substring(0, this.effectiveKey.length() - 1) : this.effectiveKey;
            String name = StringUtils.substringAfterLast((String)keyWithoutTrailingSlash, (String)"/");
            if (StringUtils.isEmpty((CharSequence)name)) {
                return keyWithoutTrailingSlash;
            }
            return name;
        }

        @Override
        public String getItemName() {
            return S3AssetIngestor.this.bucket + ":" + this.effectiveKey;
        }

        @Override
        public AssetIngestor.Source getSource() {
            if (StringUtils.isNotBlank((CharSequence)this.negativePath)) {
                return null;
            }
            return new S3Source(this.original, this);
        }

        @Override
        public String getJcrBasePath() {
            return S3AssetIngestor.this.jcrBasePath;
        }
    }

    private class S3Source
    implements AssetIngestor.Source {
        private final S3ObjectSummary s3ObjectSummary;
        private final AssetIngestor.HierarchialElement element;

        private S3Source(S3ObjectSummary s3ObjectSummary, S3HierarchialElement element) {
            this.s3ObjectSummary = s3ObjectSummary;
            this.element = element;
        }

        @Override
        public long getLength() {
            return this.s3ObjectSummary.getSize();
        }

        @Override
        public InputStream getStream() throws IOException {
            return S3AssetIngestor.this.s3Client.getObject(S3AssetIngestor.this.bucket, this.s3ObjectSummary.getKey()).getObjectContent();
        }

        @Override
        public String getName() {
            return this.element.getName();
        }

        @Override
        public AssetIngestor.HierarchialElement getElement() {
            return this.element;
        }
    }
}

