/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.mcp.AdministratorsOnlyProcessDefinitionFactory;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessDefinitionFactory;
import com.adobe.acs.commons.mcp.impl.processes.S3AssetIngestor;
import com.amazonaws.services.s3.AmazonS3Client;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.commons.mime.MimeTypeService;

@Component
@Service(value={ProcessDefinitionFactory.class})
public class S3AssetIngestorFactory
extends AdministratorsOnlyProcessDefinitionFactory<ProcessDefinition> {
    @Reference
    MimeTypeService mimetypeService;

    @Override
    public String getName() {
        return "S3 Asset Ingestor";
    }

    @Override
    public ProcessDefinition createProcessDefinitionInstance() {
        return new S3AssetIngestor(this.mimetypeService);
    }

    @Override
    public boolean isAllowed(User user) {
        if (super.isAllowed(user)) {
            try {
                new AmazonS3Client();
                return true;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return false;
    }

    protected void bindMimetypeService(MimeTypeService mimeTypeService) {
        this.mimetypeService = mimeTypeService;
    }

    protected void unbindMimetypeService(MimeTypeService mimeTypeService) {
        if (this.mimetypeService == mimeTypeService) {
            this.mimetypeService = null;
        }
    }
}

